'#########################################################################
'# 
'# AutoSuspend.vbs                    Version 1.1.0 (f)  Datum: 2000/04/05
'# 
'# (c) 2000, Wolfgang Jth <wjaeth@bigfoot.de>
'#
'#
'# Dieses Skript bringt dem Freeware News- und Mail-Server "Hamster" 
'# von Jrgen Haible ein leafnode-artiges Verhalten bei: Wenn eine 
'# Gruppe ber einen bestimmten Zeitraum von keinem User gelesen wird, 
'# wird das Pullen dieser Gruppe eingestelt. Sobald sich wieder ein 
'# User fr diese Gruppe interessiert, wird das Pullen wieder 
'# aufgenommen.
'#
'# Auerdem prft das Programm die Konsistenz zwischen den vom Hamster 
'# gefhrten Gruppen (Groups.hst) und Pulls (Pulls.hst), sowie den 
'# angelegten Gruppen-Verzeichnissen. Dabei entdeckte Unstimmigkeiten 
'# knnen automatisch korrigiert werden. So knnen z.B. Verzeichnisse, 
'# fr die im Hamster keine Gruppe (mehr) existiert, automatisch 
'# gelscht werden.
'# 
'# 
'# Die Verwendung erfolgt auf eigene Verantwortung. Der Autor schliet
'# jegliche Haftung aus.
'#
'# Diese Datei darf fr private Zwecke frei verwendet, kopiert oder
'# weitergeben werden, solange der Inhalt unverndert bleibt. nderungen
'# oder Anpassungen am Quelltext bedrfen der Genehmigung des Autors.
'#
'# Der Inhalt dieser Datei ist und bleibt geistiges Eigentum des Autors.
'#
'#########################################################################


' Allgemeine Programmbedingungen
'--------------------------------
Option explicit		' Variablendeklaration erzwingen
'On error resume next	' Kein Abbruch bei Fehler


' Konstanten
Const ForReading = 1, ForWriting = 2, ForAppEnding = 8
Const localDir = ".\"
Const tagSpace8 = "        "
Const tagCreated = "created"
Const tagLastClientRead = "lastclientread"
Const tagSuspendDelay = "autosuspend.delay"
Const tagMsgErr = "Folgende Nachricht konnte nicht abgesetzt werden:"
Const tagMsgErrSep = "------------"
Const tagMsgStart = "berprfe Abo's ..." 
Const tagMsgDone = "Abo-berprfung abgeschlossen." 
Const tagMsgSuspnd = "Ausgesetzte Gruppen:  "
Const tagMsgResume = "Wiederaufgenommen:  "
Const tagRefreshed = "Erneut gesendet:  "
Const tagReposted  = "(reposted)"	

' Dateien in .\Hamster
Const fileGroupsHst  = "Groups.hst"
Const filePullsHst   = "Pulls.hst"
Const fileSuspendHst = "Suspend.hst"
Const fileSuspendIni = "Suspend.ini"

' Dateien und Verzeichnisse in .\Hamster\Groups (und darunter)
Const subGroups = "Groups\"
Const subNewsOut = "News.Out"
Const fileDataIni = "\Data.ini"

' Registry-Eintrge
Const regCurrentNumber    = "HKCU\Software\Hamster-Script\Message-ID\SerialPart"

' Objekte und initialisierte Variablen
Dim fileSystem
Dim wshShell
Dim hamster
Dim miniOle
Dim hamsterPath
Dim msgTitle
Dim AbsMinDate


' Array der Wochentage-Namen
Dim Days (7)
    Days(1) = "Sun"  :  Days(2) = "Mon"  :  Days(3) = "Tue"  :  Days(4) = "Wed"
    Days(5) = "Thu"  :  Days(6) = "Fri"  :  Days(7) = "Sat"

' Array der Monate-Namen
Dim Months (12)
    Months(01) = "Jan"  :  Months(02) = "Feb"  :  Months(03) = "Mar"
    Months(04) = "Apr"  :  Months(05) = "May"  :  Months(06) = "Jun"
    Months(07) = "Jul"  :  Months(08) = "Aug"  :  Months(09) = "Sep"
    Months(10) = "Oct"  :  Months(11) = "Nov"  :  Months(12) = "Dec"

Dim Header (7,1)
    Const tag_ = 0, content_ = 1
    Const idxReferences = 0  :  Header (idxReferences, tag_) = "References: "  :  Header (idxReferences, content_) = ""
    Const idxSubj       = 1  :  Header (idxSubj, tag_)       = "Subject: "     :  Header (idxSubj, content_)       = ""
    Const idxDate       = 2  :  Header (idxDate, tag_)       = "Date: "        :  Header (idxDate, content_)       = ""
    Const idxFrom       = 3  :  Header (idxFrom, tag_)       = "From: "        :  Header (idxFrom, content_)       = "AutoSuspend"
    Const idxGroup      = 4  :  Header (idxGroup, tag_)      = "Newsgroups: "  :  Header (idxGroup, content_)      = ""
    Const idxMID        = 5  :  Header (idxMID, tag_)        = "Message-ID: "  :  Header (idxMID, content_)        = ""
    Const idxLines      = 6  :  Header (idxLines, tag_)      = "Lines: "       :  Header (idxLines, content_)      = ""
    Const idxBody       = 7  :  Header (idxBody, tag_)       = vbCRLF          :  Header (idxBody, content_)       = ""

Dim Subject (6)
    Const idxTag       = 0 : Subject (idxTag)       = ""
    Const idxLabel     = 1 : Subject (idxLabel)     = "[AutoSuspend]   "
    Const idxSuspended = 2 : Subject (idxSuspended) = "   ausgesetzt"
    Const idxResumed   = 3 : Subject (idxResumed)   = "   wieder aufgenommen" 
    Const idxResumeAll = 4 : Subject (idxResumeAll) = "   restauriert" 
    Const idxServer    = 5 : Subject (idxServer)    = "" 
    Const idxError     = 6 : Subject (idxError)     = "   *W*A*R*N*U*N*G*!*" 

Dim Body (6)
    Body (idxTag) = "." & vbCRLF
    Body (idxLabel)     = "Der letzte Zugriff auf diese Gruppe erfolgte am "
    Body (idxSuspended) = "Bei zuknftigem Interesse erfolgt automatisch die Wiederaufnahme (Es kann dann " & vbCRLF & _
                          "unter Umstnden jedoch etwas dauern, bis die Artikel wieder verfgbar sind)."
    Body (idxResumed)   = "Der Artikelbestand wird so schnell wie mglich aktualisiert."
    Body (idxResumeAll) = "Alle Gruppen werden restauriert. Der Artikelbestand wird so " & vbCRLF & _
                          "schnell wie mglich aktualisiert."
    Body (idxServer)    = vbCRLF & vbCRLF & "Die Gruppe wird von folgenden Servern bezogen:" & vbCRLF & String (46, "-") & vbCRLF
    Body (idxError) = ""

Dim ErrBody (3, 1)
    Const ebProblem = 0, ebAction = 1, ebGroup = 1, ebDir = 2, ebPull = 3
    ErrBody (ebProblem, ebProblem) = "Folgendes Problem wurde entdeckt:" & vbCRLF & vbCRLF
    ErrBody (ebProblem, ebAction)  = "Das Problem wurde von AutoSuspend behoben."
    ErrBody (ebGroup, ebProblem)   = "Fr diese Gruppe existiert kein Verzeichnis!" & vbCRLF & vbCRLF
    ErrBody (ebGroup, ebAction)    = "Bitte starten Sie den Hamster neu."
    ErrBody (ebDir,  ebProblem) = "Beim Lschen dieser Gruppe wurde anscheinend das Verzeichnis 'bersehen'!" & vbCRLF & vbCRLF
    ErrBody (ebDir,  ebAction)  = "bitte lschen Sie das Verzeichnis manuell."
    ErrBody (ebPull, ebProblem) = "Diese Gruppe wird von extern geladen, ohne da sie im Hamster gefhrt wird!" & vbCRLF & vbCRLF
    ErrBody (ebPull, ebAction)  = "Bitte lschen Sie den News-Pull in der Hamster-Konfiguration."


Dim IniSections (2)
    Const secidx_ = 0, secname_ = 1
    Const secUnknown = 0  :  IniSections (secUnknown) = Array (secUnknown, "[<unknown>]")
    Const secSuspend = 1  :  IniSections (secSuspend) = Array (secSuspend, "[suspend]")
    Const secScript  = 2  :  IniSections (secScript)  = Array (secScript, "[script]")


Dim IniOptions (10)
    Const optidx_ = 0, optname_ = 1, optsection_ = 2, opttype_ = 3, optvalue_ = 4, optmask_ = 5
    Const optUnknown   = 0  :  IniOptions (optUnknown)   = Array (optUnknown,    "<unknown>", secUnknown, vbError, 0)
    Const optTimeZone  = 1  :  IniOptions (optTimeZone)  = Array (optTimeZone,   "TimeZone",  secUnknown, vbString, "CET")
    Const optSerialNum = 2  :  IniOptions (optSerialNum) = Array (optSerialNum,  "SerialNum", secUnknown, vbInteger, 1)
    Const optPopupStart= 3  :  IniOptions (optPopupStart)= Array (optPopupStart, "popup.start",secScript, vbInteger, 1)
    Const optPopupDone = 4  :  IniOptions (optPopupDone) = Array (optPopupDone,  "popup.done", secScript, vbInteger, 1)
    Const optGroup     = 5  :  IniOptions (optGroup)     = Array (optGroup,      "newsgroup", secSuspend, vbString, "hamster.misc")
    Const optDelay     = 6  :  IniOptions (optDelay)     = Array (optDelay,      "delay",     secSuspend, vbInteger, 7)
    Const optInitDelay = 7  :  IniOptions (optInitDelay) = Array (optInitDelay,  "initdelay", secSuspend, vbInteger, 0)
    Const optAutoFix   = 8  :  IniOptions (optAutoFix)   = Array (optAutoFix,    "autofix",   secSuspend, vbBoolean, True)
    Const optResumeAll = 9  :  IniOptions (optResumeAll) = Array (optResumeAll,  "resumeall", secSuspend, vbBoolean, False)
    Const optRefresh   = 10 :  IniOptions (optRefresh)   = Array (optRefresh,    "refresh",   secSuspend, vbBoolean, False)



'---------------     Initialisierung     ---------------



Function LoadSerialNumber
'=========================
    On error Resume Next

    err.clear
    LoadSerialNumber = wshShell.RegRead (regCurrentNumber)
    If (err.number <> 0) Then
        err.clear
        LoadSerialNumber = 0
    end if
End Function 



Sub StoreSerialNumber (SerNumber)
'=================================
    wshShell.RegWrite regCurrentNumber, SerNumber, "REG_DWORD"
End Sub



Function LoadTimeZone
'=====================
    On error Resume Next
    Const regKey = "HKLM\System\CurrentControlSet\Control\TimeZoneInformation\ActiveTimeBias"
    Dim myTime, myZone, mySig, i1

    myZone = WshShell.RegRead (regKey)
    myTime = CInt ("&H" & Hex (myZone (3)) & Hex (myZone (2)) & Hex (myZone (1)) & Hex( myZone (0)))
    If (myTime < 0) Then
        mySig = "+"
    Else
        mySig = "-"
    End If
    myZone = Replace (Left (TimeSerial(0, myTime, 0), 5), ":", "")
    LoadTimeZone = mySig & myZone
End Function



Function GetSectionType (IniLine)
'=================================
    Dim MyLine, Section

    MyLine = LCase (Trim (IniLine))
    GetSectionType = secUnknown
    For Each Section In IniSections
        If (Left (MyLine, Len (Section (secname_))) = Section (secname_)) Then
            GetSectionType = Section (secidx_)
            Exit For	' Schlsselwort gefunden, weitere Suche sinnlos
        End If
    Next
End Function



Function GetOptionType (IniLine, SectionIdx)
'============================================
    Dim MyLine, Key

    MyLine = LCase (Trim (IniLine))
    GetOptionType = optUnknown
    For Each Key In IniOptions
        If (Left (MyLine, Len (Key (optname_))) = Key (optname_)) Then
            If (Key (optsection_) = SectionIdx) Then
                GetOptionType = Key (optidx_)
            End If
            Exit For	' Schlsselwort gefunden, weitere Suche sinnlos
        End If
    Next
End Function



Function IniOption (OptionIdx)
'==============================
    IniOption = IniOptions (OptionIdx)(optvalue_)
End Function



Function GetValue (ValueLine, OptionIdx)
'========================================
    Const yesChars = "ytjw"	'yes, true, ja, wahr'

    Select Case IniOptions (OptionIdx)(opttype_)
      Case vbInteger
        GetValue = CInt (Trim (ValueLine))
      Case vbString
        GetValue = ValueLine
      Case vbBoolean
        GetValue = CBool (InStr (1, yesChars, Left (Trim (ValueLine), 1), vbTextCompare) > 0)
      Case Else
        GetValue = IniOption (OptionIdx)
    End Select
End Function



Sub OptionsInit
'===============
    Dim myFile
    Dim myOption, myValue
    Dim mySection, myLine

    Randomize
    IniOptions (optTimeZone)(optvalue_) = LoadTimeZone
    IniOptions (optSerialNum)(optvalue_) = LoadSerialNumber

    myFile = localDir & fileSuspendIni
    If (Not fileSystem.FileExists (myFile)) Then
        myFile = hamsterPath & fileSuspendIni
    End If
    If fileSystem.FileExists (myFile) Then
        Set myFile = fileSystem.OpenTextFile (myFile, forReading)
        mySection = secUnknown
        Do While myFile.AtEndOfStream <> True
            myLine = myFile.ReadLine
            if (Len(myLine) > 0) Then
                Select Case Left (Trim (myLine), 1)
                Case ";"			' Komentarzeilen ignorieren
                Case "["			' Abschnittwechsel
                    mySection = GetSectionType (myLine)
                Case Else
                    If (InStr (myLine, "=") = 0) Then myLine = myLine & "="
                    myLine = Split (myLine, "=", 2)
                    myOption = GetOptionType (myLine(0), mySection)
                    myValue = GetValue (myLine(1), myOption)
                    IniOptions (myOption)(optvalue_) = myValue
                End Select
            End If
        Loop
        MyFile.Close
    End If
End Sub



Sub Init
'========
    Set fileSystem = WScript.CreateObject ("Scripting.FileSystemObject")
    Set wshShell = WScript.CreateObject ("WScript.Shell")
    Set hamster = WScript.CreateObject ("Hamster.App")
    Set miniOle = Wscript.CreateObject("ScriptFunctions.App")

    If (Not IsObject (hamster)) Then
        MsgBox "Hamster nicht gefunden - Ausfhrung nicht mglich.", vbOkOnly+vbCritical
        WScript.Quit
    Else
        hamsterPath = hamster.ControlGetPath
        msgTitle = "Auto-Suspend  V.1.1.0  fr Hamster (" & hamster.ControlGetVersion & ")"
    End If
    AbsMinDate = DateSerial (0101, 01, 01)

    OptionsInit
    MsgPopup tagMsgStart, IniOption (optPopupStart), msgTitle, vbOkOnly
End Sub



Sub OptionsDone
'===============
    StoreSerialNumber (IniOptions (optSerialNum)(optvalue_))
End Sub



Sub Done (ChangedMsg)
'=====================
    MsgPopup tagMsgDone & changedMsg, IniOption (optPopupDone), msgTitle, vbOkOnly+vbInformation
    OptionsDone

    WScript.DisconnectObject LastUsage
    WScript.DisconnectObject PulledGroups
    WScript.DisconnectObject SuspendedPulls

    WScript.DisconnectObject miniOle
    WScript.DisconnectObject hamster
    WScript.DisconnectObject wshShell
    WScript.DisconnectObject fileSystem
End Sub



'---------------     Funktionen     ---------------



Sub QuitScript (MessageText)
'============================
    MsgBox MessageText, VbOkOnly+vbCritical, msgTitle
    WScript.Quit
End Sub



Sub MsgPopup (MsgText, MsgDelay, MsgTitle, MsgButtons)
'======================================================
    If (MsgDelay > 0) Then 
        wshShell.Popup MsgText, MsgDelay, MsgTitle, MsgButtons
    ElseIf (MsgDelay < 0) Then 
        MsgBox MsgText, MsgButtons, MsgTitle
    End If
End Sub



Function GetCurrentTime
'=======================
    Dim MyDate, MyTime
    Dim MyWDay, MyMDay, MyMonth, MyYear, MyZone

    MyTime = CStr (Time)
    MyDate = Date
    MyWDay = Days (Weekday (MyDate))
    MyMDay = CStr (Day (MyDate))
    MyMonth = Months (Month (MyDate))
    MyYear = CStr (Year (MyDate))
    MyZone = IniOption (optTimeZone)
    GetCurrentTime = MyWDay & ", " & MyMDay & " " & MyMonth & " " & MyYear & " " & MyTime & " " & MyZone
End Function



Function GetUniqueMID (GroupName)
'=================================
    Dim MyDate
    Dim MyMID

    MyDate = Now
    MyMID = "<" & CStr (Year (MyDate)) & CStr (Month (MyDate)) & CStr (Day (MyDate)) & _
            CStr (Hour (MyDate)) & CStr (Minute (MyDate)) & CStr (Second (MyDate)) & _
            "." & Hex (65536 * Rnd) & "." & Hex (65536 * Rnd) & "." & _
            CStr (IniOption (optSerialNum)) & "@autosuspend.localhost>"
    IniOptions (optSerialNum)(optvalue_) = IniOption (optSerialNum) + 1
    GetUniqueMID = MyMID
End Function



Function GetClientRead (LastClientRead)
'=======================================
    If (LastClientRead > AbsMinDate) Then
        GetClientRead = CStr (LastClientRead)
    Else
        GetClientRead = "<unbekannt>"
    End If
End Function



Function GetDate (TheDate)
'==========================
    Dim myDate, myYear, myMonth, myDay

    myDate = Trim (TheDate)
    myYear = CInt (Mid (myDate, 1, 4))
    myMonth = CInt (Mid (myDate, 5, 2))
    myDay = CInt (Mid (myDate, 7, 2))
    GetDate = DateSerial (myYear, myMonth, myDay)
End Function



Function Tomorrow
'=================
    Tomorrow = Date + 1
End Function



Function CountLines (Body)
'==========================
    Dim MyLines

    MyLines = Split (Body, vbCRLF)
    CountLines = UBound (MyLines) + 1
End Function



Function SendMessage (GroupName, LastClientRead, ForSuspend, BodyText, RefMID)
'==============================================================================
    Dim myMessage, i1, myMID

    Header (idxReferences, content_) = RefMID
    Header (idxSubj, content_)  = Subject(idxLabel) & GroupName & Subject(ForSuspend)
    Header (idxDate, content_)  = GetCurrentTime
    Header (idxGroup, content_) = IniOption (optGroup) & "," & GroupName
    Header (idxMID, content_)   = GetUniqueMID (GroupName)
    If (ForSuspend = idxError) Then
        Header (idxBody, content_)  = ErrBody (ebProblem,ebProblem) & BodyText
    Else

        Header (idxBody, content_)  = Body(idxLabel) & GetClientRead(LastClientRead) & Body(idxTag) & Body(ForSuspend) & _
                                      Body (idxServer) & Replace (tagSpace8&BodyText, ",", vbCRLF&tagSpace8)
    End If
    Header (idxLines, content_) = CountLines (Header (idxBody, content_))

    myMessage = ""
    If (Len (RefMID) > 0) Then
        myMessage = myMessage & Header (idxReferences, tag_) & Header (idxReferences, content_) & vbCRLF
    End If
    For i1 = 1 To UBound (Header, 1)
        myMessage = myMessage & Header (i1, tag_) & Header (i1, content_) & vbCRLF
    Next
    myMID = hamster.NewsImport (myMessage, "", False, True)
    If (myMID = False) Then 
        MsgBox tagMsgErr & vbCR & tagMsgErrSep & vbCR & myMessage & tagMsgErrSep
    Else
        myMID = Header (idxMID, content_)
    End If
    SendMessage = myMID
End Function



Function CheckMessage (MessageID, GroupName, LastClientRead, BodyText, ByRef Refreshed)
'=======================================================================================
    Dim myMID, myGroupname, ArtNo

    If (hamster.NewsLocateMID2 (MessageID, myGroupname, ArtNo)) Then
        CheckMessage = MessageID
    Else
        If IniOption (optRefresh) Then
            Refreshed = Refreshed + 1	
            CheckMessage = SendMessage (groupName, LastClientRead, idxSuspended, BodyText & vbCR & tagReposted, MessageID)
        End If
    End If
End Function



Sub ClearMessage (MessageID)
'============================
    Dim i1, Groupname, ArtNo

    If (hamster.NewsLocateMID2 (MessageID, Groupname, ArtNo)) Then
        i1 = 10
        Do While (i1 > 0)	' max. 10 x Lschversuche
            If (hamster.NewsDeleteByMID (MessageID)) Then
                i1 = i1 - 1
            Else
                i1 = 0
            End If
        Loop
    End If
End Sub



Function SortedList (KeyList)
'=============================
    Dim tempKey, i1, i2, ok

    For i1 = 1 to UBound (KeyList)
        If (KeyList(i1) < KeyList(i1-1)) Then
            tempKey = KeyList(i1)
            i2 = i1
            ok = (KeyList(i2) < KeyList(i2-1))
            Do
                KeyList(i2) = KeyList(i2-1)
                i2 = i2 - 1
                ok = i2 > 0
                If ok Then ok = (tempKey < KeyList(i2-1))
            Loop While ok
            KeyList(i2) = tempKey
        End If
    next
    SortedList = KeyList
End Function



Function GetAllDirs
'===================
    Dim allDirs, groupList, myGroup

    Set allDirs = CreateObject ("Scripting.Dictionary")
    allDirs.CompareMode = vbTextCompare

    groupList = hamsterPath & subGroups
    If (Not fileSystem.FolderExists (groupList)) Then
        QuitScript "Verzeichnis nicht gefunden: " & groupList
    Else
        Set groupList = fileSystem.GetFolder (groupList)
        For Each myGroup In groupList.SubFolders
            allDirs.Add myGroup.Name, 0
        Next
        If allDirs.Exists (subNewsOut) Then 
            allDirs.Remove (subNewsOut)
        End If
        WScript.DisconnectObject groupList
    End If
    Set GetAllDirs = allDirs
End Function



Function GetLastUsage
'=====================
    Dim allDirs, allGroups, groupList, myGroup, myLine, iniFile
    Dim myDates, maxDate

    Set allGroups = CreateObject ("Scripting.Dictionary")
    allGroups.CompareMode = vbTextCompare

    Set allDirs = GetAllDirs
    maxDate = AbsMinDate
    groupList = hamsterPath & fileGroupsHst
    If (Not fileSystem.FileExists (groupList)) Then
        QuitScript "Datei nicht gefunden: " & groupList
    Else
        Set groupList = fileSystem.OpenTextFile (groupList, forReading)
        Do While (groupList.AtEndOfStream <> True)
            myGroup = Trim (groupList.ReadLine)
            If (Not allGroups.Exists (myGroup)) Then
                If allDirs.Exists (myGroup) Then
                    allDirs.Remove (myGroup)
                Else
                    If IniOption (optAutoFix) Then
                        fileSystem.CreateFolder (hamsterPath & subGroups & myGroup)
                        myLine = ErrBody (ebGroup,ebProblem) & ErrBody (ebProblem,ebAction)
                    Else
                        myLine = ErrBody (ebGroup,ebProblem) & ErrBody (ebGroup,ebAction)
                    End If
                    SendMessage myGroup, AbsMinDate, idxError, myLine, ""
                End If
                iniFile = hamsterPath & subGroups & myGroup & fileDataIni
                If fileSystem.FileExists (iniFile) Then
                    myDates = Array (AbsMinDate, Null, IniOption (optDelay), Null)
                    Set iniFile = fileSystem.OpenTextFile (iniFile, forReading)
                    Do While (iniFile.AtEndOfStream <> True)
                        myLine = Split (Trim (iniFile.ReadLine)&"=", "=")
                        myLine(0) = LCase (Trim (myLine(0)))
                        Select Case myLine(0)
                          Case tagCreated
                            myDates(3) = GetDate (myLine(1)) + IniOption (optInitDelay)
                          Case tagLastClientRead
                            myDates(1) = GetDate (myLine(1))
                            If (maxDate < myDates(1)) Then maxDate = myDates(1)
                          Case tagSuspendDelay                    
                            myLine(1) = Trim (Replace (myLine(1), vbTAB, " "))
                            myDates(2) = CInt (Mid (myLine(1), 1, InStr (myLine(1)&" ", " ") ) )
                        End Select
                    Loop
                    iniFile.Close
                End If
                If IsNull (myDates(1)) Then
                    myDates(0) = myDates(3) + IniOption (optInitDelay) + myDates(2)
                Else
                    myDates(0) = myDates(1) + myDates(2)
                End If
                If (myDates(2) = 0) Then
                    myDates(0) = Tomorrow
                End If
                allGroups.Add myGroup, Array (myDates(0), myDates(1))
            End If
        Loop
        groupList.Close
        allGroups.Add 0, maxDate
    End If

    For Each myGroup In allDirs.Keys
        If IniOption (optAutoFix) Then
            fileSystem.DeleteFolder (hamsterPath & subGroups & myGroup)
            myLine = ErrBody (ebDir,ebProblem) & ErrBody (ebProblem,ebAction)
        Else
            myLine = ErrBody (ebDir,ebProblem) & ErrBody (ebDir,ebAction)
        End If
        SendMessage myGroup, AbsMinDate, idxError, myLine, ""
    Next

    WScript.DisconnectObject allDirs
    Set GetLastUsage = allGroups
End Function



Function GetLastReading (LastUsage)
'===================================
    GetLastReading = LastUsage.Item(0)
    LastUsage.Remove(0)
End Function



Function GetPulledGroups
'========================
    Dim allPulls, pullingList, myLine

    Set allPulls = CreateObject ("Scripting.Dictionary")
    allPulls.CompareMode = vbTextCompare

    pullingList = hamsterPath & filePullsHst
    If (Not fileSystem.FileExists (pullingList)) Then
        QuitScript "Datei nicht gefunden: " & pullingList
    Else
        Set pullingList = fileSystem.OpenTextFile (pullingList, forReading)
        Do While (pullingList.AtEndOfStream <> True)
            myLine = Split (Trim (pullingList.ReadLine), ",")
            If allPulls.Exists (myLine(0)) Then
                allPulls.Item (myLine(0)) = allPulls.Item (myLine(0)) & "," & myLine(1)
            Else
                allPulls.Add myLine(0), myLine(1)
            End If
        Loop
        pullingList.Close
    End If
    Set GetPulledGroups = allPulls
End Function



Function GetSuspendedPulls
'==========================
    Dim suspPulls, suspList, myLine

    Set suspPulls = CreateObject ("Scripting.Dictionary")
    suspPulls.CompareMode = vbTextCompare

    suspList = hamsterPath & fileSuspendHst
    If fileSystem.FileExists (suspList) Then
        Set suspList = fileSystem.OpenTextFile (suspList, forReading)
        Do While (suspList.AtEndOfStream <> True)
            myLine = Split (Trim (suspList.ReadLine), ",", 2)
            If (Not suspPulls.Exists (myLine(0))) Then
                suspPulls.Add myLine(0), myLine(1)
            End If
        Loop
        suspList.Close
    End If
    Set GetSuspendedPulls = suspPulls
End Function



Sub WritePulledGroups (ByRef PulledGroups)
'==========================================
    Dim sortedPulls, pullingList, myPull, myServer

    pullingList = hamsterPath & filePullsHst
    Set pullingList = fileSystem.OpenTextFile (pullingList, forWriting, True)

    sortedPulls = SortedList (PulledGroups.Keys)
    For Each myPull In sortedPulls
        For Each myServer In Split (PulledGroups.Item (myPull), ",")
            pullingList.WriteLine myPull & "," & myServer
        Next
    Next
    pullingList.Close
End Sub



Sub WriteSuspendedPulls (ByRef SuspendedPulls)
'==============================================
    Dim sortedPulls, suspList, myPull

    suspList = hamsterPath & fileSuspendHst
    Set suspList = fileSystem.OpenTextFile (suspList, forWriting, True)
    sortedPulls = SortedList (SuspendedPulls.Keys)
    For Each myPull In sortedPulls
        suspList.WriteLine myPull & "," & SuspendedPulls.Item (myPull)
    Next
    suspList.Close
End Sub



Function CheckForSuspend (ByRef PulledGroups, ByRef SuspendedPulls, LastUsage, ReadingDelay)
'============================================================================================
    Dim groupName, myMID, myLine
    Dim isChanged

    If IniOption (optResumeAll) Then
        ReadingDelay = AbsMinDate
    End If
    isChanged = 0
    For Each groupName in PulledGroups.Keys
        If (Not LastUsage.Exists (groupName)) Then
            If IniOption (optAutoFix) Then
                PulledGroups.Remove (groupName)
                isChanged = isChanged + 1
                myLine = ErrBody (ebPull,ebProblem) & ErrBody (ebProblem,ebAction)
            Else
                myLine = ErrBody (ebPull,ebProblem) & ErrBody (ebPull,ebAction)
            End If
            SendMessage groupName, AbsMinDate, idxError, myLine, ""
        Else
            If (LastUsage.Item (groupName)(0) <= ReadingDelay) Then
                myMID = SendMessage (groupName, LastUsage.Item (groupName)(1), idxSuspended, PulledGroups.Item (groupName), "")
                If (myMID <> False) Then
                    If SuspendedPulls.Exists (groupName) Then
                        SuspendedPulls.Remove (groupName)
                    End If
                    SuspendedPulls.Add groupName, PulledGroups.Item (groupName) & ";" & myMID
                    PulledGroups.Remove (groupName)
                    isChanged = isChanged + 1
                End If
            End If
        End If
    Next
    CheckForSuspend = isChanged
End Function



Function CheckForResume (ByRef SuspendedPulls, ByRef PulledGroups, LastUsage, ReadingDelay, ByRef Refreshed)
'============================================================================================================
    Dim groupName, myMID, myServer, myResume
    Dim isChanged

    If IniOption (optResumeAll) Then
        ReadingDelay = AbsMinDate - 1
        myResume = idxResumeAll
    Else
        myResume = idxResumed
    End If
    Refreshed = 0
    isChanged = 0
    For Each groupName in SuspendedPulls.Keys
        If (Not LastUsage.Exists (groupName)) Then
            SuspendedPulls.Remove (groupName)
        Else
            myServer = Split (SuspendedPulls.Item(groupName)&";", ";")
            If (LastUsage.Item (groupName)(0) > ReadingDelay) Then
                myMID = SendMessage (groupName, LastUsage.Item (groupName)(1), myResume, myServer(0), myServer(1))
                If (myMID <> False) Then
                    ClearMessage myServer(1)
                    If (Not PulledGroups.Exists (groupName)) Then
                        PulledGroups.Add groupName, myServer(0)
                        isChanged = isChanged + 1
                    End If
                    SuspendedPulls.Remove (groupName)
                End If
            Else
                myServer(1) = CheckMessage (myServer(1), groupName, LastUsage.Item (groupName)(1), myServer(0), Refreshed)
                SuspendedPulls.Item(groupName) = myServer(0) & ";" & myServer(1)
            End If
        End If
    Next
    CheckForResume = isChanged
End Function



Sub CheckHamsterConfig (AutoClose)
'==================================
    Const HamsterConfig = "The Hamster [X] Configuration"

    If (miniOle.WindowExists (HamsterConfig)) Then
        If AutoClose Then
            miniOle.CloseWindow (HamsterConfig)
        Else
            QuitScript "ABBRUCH!" & vbCR & vbCR & "Das Hamster-Konfigurationsfenster ist geffnet. Um mglichen" & vbCR & _
			"Problemen vorzubeugen, wird das Skript abgebrochen."
        End If
    End If
End Sub



' Main
'======
    Dim PulledGroups, SuspendedPulls
    Dim LastUsage, lastReading
    Dim changedSuspend, changedResume, changedRefresh, changedMsg

    Init

    CheckHamsterConfig FALSE
    Set LastUsage = GetLastUsage
    Set PulledGroups = GetPulledGroups
    Set SuspendedPulls = GetSuspendedPulls
    lastReading = GetLastReading (LastUsage)

    CheckHamsterConfig FALSE
    changedSuspend = CheckForSuspend (PulledGroups, SuspendedPulls, LastUsage, lastReading)
    changedResume = CheckForResume (SuspendedPulls, PulledGroups, LastUsage, lastReading, changedRefresh)

    CheckHamsterConfig FALSE
    WriteSuspendedPulls (SuspendedPulls)
    If ((changedSuspend + changedResume) > 0) Then
        CheckHamsterConfig TRUE
        WritePulledGroups (PulledGroups)
        CheckHamsterConfig TRUE
        changedMsg = vbCR & vbCR & tagMsgSuspnd & CStr (changedSuspend) & vbCR & tagMsgResume & CStr (changedResume)
    Else
        changedMsg = ""
    End If
    If (changedRefresh > 0) Then
        If (Len(changedMsg) <= 0) Then
            changedMsg = vbCr
        End If
        changedMsg = changedMsg & vbCr & tagRefreshed & CStr (changedRefresh)
    End If

    Done changedMsg
' Main End
WScript.Quit

