'Hamvb.vbs - A Hamster script by Tom Snyder
'Based on Demo-Session.vbs by Juergen Haible - juergen.haible@gmx.de

'~~Author of ActiveConnection section~~.          Michael Harris
'~~Email_Address~~. mikhar@ibm.net
'~~Script_Type~~.   Vbscript
'~~Sub_Type~~. SystemAdministration
'~~Keywords~~.      Remote Connection detection, Shell.RegRead, RAS


Dim OLAlready
Dim proclist
Dim num
Dim msgs
Dim Fold
Dim Mails

'Preferences
Const RASDIAL_CONNECTION     = "Nerc Franklin"         'Name of RAS-conn; "" = disable dialing
Const RASDIAL_USERNAME       = ""         'Username for RAS-conn; "" = use Hamster-setting
Const RASDIAL_PASSWORD       = ""         'Password for RAS-conn; "" = use Hamster-setting
Const prgName                = "C:\Program Files\POP3 Scan Mailbox\SCANMAIL.EXE"

'Initialize Hamster-constants
Const HAM_PURGEOPT_DOALL     = &HF
Const HAM_PURGEOPT_DONEWS    = &H1
Const HAM_PURGEOPT_DOHISTORY = &H2
Const HAM_PURGEOPT_DOKILLS   = &H4
Const HAM_WAITIDLE_INFINITE  = 0
Const HAM_MSG_HAMSTER_EXIT    = 1
Const HAM_MSG_RESET_COUNTERS  = 2
Const HAM_MSG_LOCALNNTP_ONOFF = 3
Const HAM_MSG_LOCALPOP3_ONOFF = 4
Const HAM_MSG_LOCALSMTP_ONOFF = 5


'Initialize objects
'Note: Hamster.exe will be loaded now if does not run already.
Set Hamster = Wscript.CreateObject("Hamster.App")
Set proclist = CreateObject("WshKit.Process")
Set shell = CreateObject("WScript.Shell")
Set fso = CreateObject("Scripting.FileSystemObject")


'Cleans out log and counters and then purges
Hamster.ControlMessage HAM_MSG_RESET_COUNTERS,0
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
Hamster.ControlRunPurge HAM_PURGEOPT_DOALL
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE


If ActiveConnection() Then
	OLAlready = True
Else If Connected() Then
	OLAlready = False
     Else WScript.Quit
     End If
End If

Hamster.ControlRunNewsPost ""
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
WScript.Sleep 10000
Hamster.ControlRunMail ""
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
WScript.Sleep 30000
Hamster.ControlRunNewsPull ""
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

If OLAlready = False Then
   Hamster.RasHangup
End If

Set Fold = fso.GetFolder("C:\Program Files\Hamster\Mails\admin")
Set Mails = Fold.Files
msgs = Mails.Count
If msgs = 0 Then
    num = 0
Else proclist.Load
       num = proclist.Find(Chr(34) & prgName & Chr(34))
       If num < 1 Then
          shell.Run Chr(34) & prgName & Chr(34) & "/W1", 6, False
       End If
End If


'Release Hamster-object
Set Hamster = Nothing
Set proclist = Nothing
Set shell = Nothing
Set fso = Nothing
WScript.Quit

Function ActiveConnection() 'As Boolean
   
    'this function checks the registry for
    'an active connection 
    '
    'works for dialup internet connection. 
    'haven't tested with LAN connection to internet.

    Dim vKeyString 'As String
    Dim vKeyData 'As Long
    Dim oShell 'As Shell
    Dim vMsg2 'As String

    vKeyString = "HKLM\System\CurrentControlSet\Services\RemoteAccess\Remote Connection"
   
    Set oShell = CreateObject("WScript.Shell")
    
    On Error Resume Next 

    vKeyData = oShell.RegRead(vKeyString)
    
    If Err <> 0 Then
        if Err = &H80070003 then
            vMsg2 = "Invalid Root key" & vbCrLf & vKeyString
        ElseIf Err = &H80070002 then
            vMsg2 = "Sub key or ValueName invalid or not found" & vbCrLf & vKeyString
        else
            vMsg2 = Err.Description & vbCrLf & vKeyString 
        End If
    	MsgBox "Error in ActiveConnection:RegRead " & HexError(Err.Number) _
             & vbCrLf & vMsg2 
    	Exit Function
    End If
    
    On Error GoTo 0 'clears Err and disables error trapping


    ActiveConnection = (vKeyData(0) = 1)

End Function

Function HexError(vErrNumber)
	HexError = "<0x" & Right("00000000" & Hex(vErrNumber), 8) & ">"
End Function

Function Connected()  'Tries to dial out up to 5 times
   Dim count
   Dim DialErr
   count = 0
   Connected = False
   Do Until count > 4
   If
Hamster.RasDial(RASDIAL_CONNECTION,RASDIAL_USERNAME,RASDIAL_PASSWORD)
Then
      Connected = True
      count = 5
   Else DialErr = Hamster.RasLastError
      Select Case DialErr

         Case 676  'The line is busy
            WScript.Sleep 30000
            count = count + 1

         Case 678  'There is no answer
            WScript.Sleep 30000
            count = count + 1

         Case 679  'Cannot detect carrier
            WScript.Sleep 30000
            count = count + 1

         Case 680  'There is no dialtone
            WScript.Sleep 30000
            count = count + 1

         Case Else  'Unknown error
            count = 5

       End Select
    End If
    Loop
End Function 
            
            