'#########################################################################
'# 
'# MailMan.vbs                        Version 1.1.1 (d)  Datum: 2000/04/05
'# 
'# (c) 2000, Wolfgang Jth <wjaeth@bigfoot.de>
'#
'#
'# Dieses Skript dient im Zusammenhang mit dem Freeware News- und 
'# Mail-Server "Hamster" von Jrgen Haible dazu, vom Mailreader aus 
'# die im Hamster-Mailfilter 'hngengebliebenen' Mails nachladen oder 
'# entsorgen zu lassen. Dazu mu nur eine Antwortmail an den Hamster 
'# (bzw. das Skript) zurckgeschickt werden. Das Skript wertet den 
'# Subject-Header aus und modifiziert die Datei MailFilt.hst 
'# entsprechend. 
'# 
'# Bsp: 'load Message-ID: <local.part@domain.name>'
'# 
'# 
'# Die Verwendung erfolgt auf eigene Verantwortung. Der Autor schliet
'# jegliche Haftung aus.
'#
'# Diese Datei darf fr private Zwecke frei verwendet, kopiert oder
'# weitergeben werden, solange der Inhalt unverndert bleibt. nderungen
'# oder Anpassungen am Quelltext bedrfen der Genehmigung des Autors.
'#
'# Der Inhalt dieser Datei ist und bleibt geistiges Eigentum des Autors.
'#
'#########################################################################


' Allgemeine Programmbedingungen
'--------------------------------
Option explicit		' Variablendeklaration erzwingen
'On error resume next	' Kein Abbruch bei Fehler


' Konstanten
Const ForReading = 1, ForWriting = 2, ForAppEnding = 8
Const tagMsgStart = "Starte MailMan ..." 
Const tagMsgDone  = "MailMan abgeschlossen." 
Const tagMailMan  = "MailMan"
Const tagSubject  = "subject:" 
Const tagFrom     = "from:" 
Const tagDate     = "date:" 

' Messages und Texte
Const errDir = "Das folgende Verzeichnis konnte nicht gefunden werden. Bitte berprfen Sie Ihre Einstellungen."

' Dateien in .\Hamster
Const localDir = ".\"
Const fileMailIni = "MailMan.ini"
Const fileMailFilt = "MailFilt.hst"
Const subMail = "Mails\"

' Objekte und initialisierte Variablen
Dim fileSystem
Dim wshShell
Dim hamster
Dim hamsterPath
Dim msgTitle


Dim IniSections (2)
    Const secidx_ = 0, secname_ = 1
    Const secUnknown = 0  :  IniSections (secUnknown) = Array (secUnknown, "[<unknown>]")
    Const secScript  = 1  :  IniSections (secScript)  = Array (secScript, "[script]")
    Const secMailMan = 2  :  IniSections (secMailMan) = Array (secMailMan, "[mailman]")


Dim IniOptions (4)
    Const optidx_ = 0, optname_ = 1, optsection_ = 2, opttype_ = 3, optvalue_ = 4, optmask_ = 5
    Const optUnknown   = 0  :  IniOptions (optUnknown)   = Array (optUnknown,    "<unknown>", secUnknown, vbError, 0)
    Const optPopupStart= 1  :  IniOptions (optPopupStart)= Array (optPopupStart, "popup.start",secScript, vbInteger, 0)
    Const optPopupDone = 2  :  IniOptions (optPopupDone) = Array (optPopupDone,  "popup.done", secScript, vbInteger, 0)
    Const optMailExt   = 3  :  IniOptions (optMailExt)   = Array (optMailExt,    "MailExt",   secUnknown, vbString, ".msg")
    Const optAccount   = 4  :  IniOptions (optAccount)   = Array (optAccount,    "account",   secMailMan, vbString, "MailMan")


Dim Actions
    Set Actions = CreateObject ("Scripting.Dictionary")
    Actions.CompareMode = vbTextCompare
    Actions.Add "load",  TRUE
    Actions.Add "=load", TRUE
    Actions.Add "kill",  TRUE
    Actions.Add "=kill", TRUE
'    Actions.Add "Remove", FALSE



'---------------     Initialisierung     ---------------



Sub QuitScript (MessageText)
'============================
    MsgBox MessageText, VbOkOnly + vbCritical, msgTitle
    WScript.Quit
End Sub



Sub MsgPopup (MsgText, MsgDelay, MsgTitle, MsgButtons)
'======================================================
    If (MsgDelay > 0) Then 
        wshShell.Popup MsgText, MsgDelay, MsgTitle, MsgButtons
    ElseIf (MsgDelay < 0) Then 
        MsgBox MsgText, MsgButtons, MsgTitle
    End If
End Sub



Function GetSectionType (IniLine)
'=================================
    Dim MyLine, Section

    MyLine = LCase (Trim (IniLine))
    GetSectionType = secUnknown
    For Each Section In IniSections
        If (Left (MyLine, Len (Section (secname_))) = Section (secname_)) Then
            GetSectionType = Section (secidx_)
            Exit For	' Schlsselwort gefunden, weitere Suche sinnlos
        End If
    Next
End Function



Function GetOptionType (IniLine, SectionIdx)
'============================================
    Dim MyLine, Key

    MyLine = LCase (Trim (IniLine))
    GetOptionType = optUnknown
    For Each Key In IniOptions
        If (Left (MyLine, Len (Key (optname_))) = Key (optname_)) Then
            If (Key (optsection_) = SectionIdx) Then
                GetOptionType = Key (optidx_)
            End If
            Exit For	' Schlsselwort gefunden, weitere Suche sinnlos
        End If
    Next
End Function



Function IniOption (OptionIdx)
'==============================
    IniOption = IniOptions (OptionIdx)(optvalue_)
End Function



Function GetValue (ValueLine, OptionIdx)
'========================================
    Const yesChars = "ytjw"	'yes, true, ja, wahr'

    Select Case IniOptions (OptionIdx)(opttype_)
      Case vbInteger
        GetValue = CInt (Trim (ValueLine))
      Case vbString
        GetValue = Trim (ValueLine)
      Case vbBoolean
        GetValue = CBool (InStr (1, yesChars, Left (Trim (ValueLine), 1), vbTextCompare) > 0)
      Case Else
        GetValue = IniOption (OptionIdx)
    End Select
End Function



Sub OptionsInit
'===============
    Dim myFile
    Dim myOption, myValue
    Dim mySection, myLine

    myFile = localDir & fileMailIni
    If (Not fileSystem.FileExists (myFile)) Then
        myFile = hamsterPath & fileMailIni
    End If
    If fileSystem.FileExists (myFile) Then
        Set myFile = fileSystem.OpenTextFile (myFile, ForReading)
        mySection = secUnknown
        Do While myFile.AtEndOfStream <> True
            myLine = myFile.ReadLine
            if (Len(myLine) > 0) Then
                Select Case Left (Trim (myLine), 1)
                Case ";"			' Komentarzeilen ignorieren
                Case "["			' Abschnittwechsel
                    mySection = GetSectionType (myLine)
                Case Else
                    If (InStr (myLine, "=") = 0) Then myLine = myLine & "="
                    myLine = Split (myLine, "=", 2)
                    myOption = GetOptionType (myLine(0), mySection)
                    myValue = GetValue (myLine(1), myOption)
                    IniOptions (myOption)(optvalue_) = myValue
                End Select
            End If
        Loop
        MyFile.Close
    End If
End Sub



Sub OptionsDone
'===============
End Sub



Sub Init
'========
    Set fileSystem = WScript.CreateObject ("Scripting.FileSystemObject")
    Set wshShell = WScript.CreateObject ("WScript.Shell")
    Set hamster = WScript.CreateObject ("Hamster.App")
    If (Not IsObject (hamster)) Then
        MsgBox "Hamster nicht gefunden - Ausfhrung nicht mglich.", vbOkOnly+vbCritical
        WScript.Quit
    Else
        hamsterPath = hamster.ControlGetPath
        msgTitle = "MailMan  V.1.0.1  fr Hamster (" & hamster.ControlGetVersion & ")"
    End If

    OptionsInit
    MsgPopup tagMsgStart & vbcr & IniOptions(optAccount)(optvalue_), IniOption (optPopupStart), msgTitle, vbOkOnly
End Sub



Sub Done
'========
    MsgPopup tagMsgDone, IniOption (optPopupDone), msgTitle, vbOkOnly + vbInformation
    OptionsDone

    WScript.DisconnectObject hamster
    WScript.DisconnectObject wshShell
    WScript.DisconnectObject fileSystem
End Sub



'---------------     Funktionen     ---------------



Function SplitPattern (ThePattern)
'==================================
    Dim myTags, myPattern, mySpace, i1

    myTags = Array ("", "", "", "")

    myPattern = Trim (thePattern) & " "
    If (Left (myPattern, 1) = "[") Then
        mySpace = InStr (1, myPattern, " ")
        myTags(3) = Left (myPattern, mySpace-1)
        myPattern = LTrim (Mid (myPattern, mySpace))
    End If

    For i1 = 0 To 1
        mySpace = InStr (1, myPattern, " ")
        If (mySpace > 1) Then
            myTags(i1) = Left (myPattern, mySpace-1)
            myPattern = LTrim (Mid (myPattern, mySpace))
        End If
    Next

    myPattern = RTrim (myPattern)
    mySpace = Right (myPattern, 1)
    If (InStr ("""'", mySpace) = 0) Then
        mySpace = " "
    ElseIf (Left (myPattern, 1) <> mySpace) Then
        mySpace = " "
    End If
    Select Case mySpace
        Case """"	' do nothing
            myTags(2) = myPattern
        Case "'"	' remove inverted comma
            myTags(2) = Mid (myPattern, 2, Len (myPattern)-2)
        Case else	' add qoutation marks
            myTags(2) = """" & myPattern & """"
    End Select

    SplitPattern = myTags
End Function



Sub SetFilter (TheAction, TheHeader, TheMatch, TheFrom, TheDate)
'================================================================
    Dim myFile, myFilterFile

    If ((Len (TheAction) > 0) AND (Len (TheHeader) > 0)) Then
        If (Actions.Item (TheAction) = TRUE) Then
            myFilterFile = hamsterPath & fileMailFilt
            Set myFile = fileSystem.OpenTextFile (myFilterFile, ForAppending, TRUE)
            myFile.WriteLine
            myFile.WriteLine (vbTAB & "# " & tagMailMan & ", " & FormatDateTime(Now, vbGeneralDate))
            myFile.WriteLine ("[*]" & vbTAB & "# " & TheFrom & " / " & TheDate)
            myFile.WriteLine (LCase(TheAction) & " " & TheHeader & " " & TheMatch)
            WScript.DisconnectObject myFile
        End If
    End If
End Sub



Sub ParseMail (TheMail)
'=======================
    Dim myFile, myLine, i1
    Dim mySubject, lenSubject, myFrom, lenFrom, myDate, lenDate

    mySubject = ""
    lenSubject = Len (tagSubject)
    myFrom = ""
    lenFrom = Len (tagFrom)
    myDate = ""
    lenDate = Len (tagDate)

    Set myFile = FileSystem.OpenTextFile (TheMail, forReading)
    myLine = vbCRLF
    Do While ((Len (myLine) > 0) AND (Not myFile.AtEndOfStream))
        myLine = Trim (myFile.ReadLine)
        If (Len (myLine) > 0) Then
            If (LCase (Left (myLine, lenSubject)) = tagSubject) Then
                mySubject = Trim (Mid (myLine, lenSubject+1))
            ElseIf (LCase (Left (myLine, lenFrom)) = tagFrom) Then
                myFrom = Trim (myLine)
            ElseIf (LCase (Left (myLine, lenDate)) = tagDate) Then
                myDate = Trim (myLine)
            End If
        End If
    Loop
    myFile.Close
    WScript.DisconnectObject myFile

    If (Len (mySubject) > 0) Then			' Das '&"  "' garantiert, da mindestens 3 Elemente 
        myLine = SplitPattern (MySubject)		' erzeugt werden.
        If Actions.Exists (myLine(0)) Then
            SetFilter myLine(0), myLine(1), myLine(2), myFrom, myDate
        End If
    End If

    WScript.DisconnectObject MailAccount
End Sub



' Main
'======
    Dim MailAccount, ExistingMail, myExt, myExtLen

    Init
    myExt = IniOptions(optMailExt)(optvalue_)
    myExtLen = Len (myExt)

    MailAccount = hamsterPath & subMail & IniOptions(optAccount)(optvalue_)
    If (Not FileSystem.FolderExists (MailAccount)) Then
        QuitScript errDir & vbCR & vbCR & MailAccount
    Else
        Set MailAccount = FileSystem.GetFolder (MailAccount)
        For each ExistingMail in MailAccount.Files
            If (LCase (Right (ExistingMail.Name, myExtLen)) = myExt) Then
                ParseMail ExistingMail.Path
            End If
            FileSystem.DeleteFile (ExistingMail.Path)
        next
        WScript.DisconnectObject MailAccount
    End If

    Done
' Main End
WScript.Quit



