'*************************************************************************
'* Autor:   Heiko Rost                                 heiko.rost@gmx.de *
'* Version: 1.1                                                          *
'* Datum:   15.01.2000                                                   *
'*                                                                       *
'* Dieses Script wertet die Log-Dateien des Hamster aus, ob vom News-    *
'* reader Artikel per MsgId angefordert wurden. Sind diese nicht im      *
'* Hamster vorhanden, wird die Suche an alle Pull-Server weitergeleitet. *
'* Standardmig werden die neuesten 20 Logs verarbeitet, diese Zahl     *
'* ist in der Konstanten LogAnzahl festgelegt und kann bei Bedarf        *
'* gendert werden.                                                      *
'*                                                                       *
'* Das Script sollte nur in Verbindung mit Newsreadern genutzt werden,   *
'* die die Artikel normalerweise ber Artikelnummer vom Hamster abholen  *
'* (z. B. Forte Agent). Andernfalls mu eine sehr groe Anzahl von       *
'* MsgIds verarbeitet werden, was einige Zeit in Anspruch nimmt.         *
'*                                                                       *
'* Bei der Rckmeldung, wieviel Artikel noch zu laden sind, wird die     *
'* Anzahl aus den per Killfile und ber dieses Script ermittelten MsgId  *
'* gebildet. Die Zahl kann deshalb von der in den Logs gefundenen ab-    *
'* weichen.                                                              *
'*                                                                       *
'* Das Laden per MsgId (egal ob ber diese Script oder per Killfile)     *
'* kann im Hamster (Stand: Vrs. 1.3.10) Dupes erzeugen. Das hat keine    *
'* weiteren negativen Auswirkungen, Jrgen will das Problem in einer     *
'* spteren Version beheben.                                             *
'*************************************************************************

option explicit

Const ForReading = 1, ForWriting = 2, ForAppending = 8  'intern
const LogAnzahl=20              'wieviel Logs lesen
dim LogPfad                     'Pfad zu Logs
dim ServerPfad                  'Pfad zu Servern

dim AlleMsgIds                  'alle MsgId aus Logs
dim DateiSystem,Hamster         'WSH-Objekte
dim AnzahlSuchen                'wieviel Suchanfragen weitergeleitet
dim ServerListe,ServerName      'alle Newsserver
dim i

set DateiSystem = CreateObject("Scripting.FileSystemObject")
set Hamster=Wscript.CreateObject( "Hamster.App" )

AnzahlSuchen=0
ServerPfad = Hamster.ControlGetPath & "server\"
LogPfad = Hamster.ControlGetPath & "logs\"

call LogsLesen                  'Logs durchsuchen

'MsgId an alle Server weiterreichen
set ServerListe=DateiSystem.OpenTextFile(Hamster.ControlGetPath & "server.hst")
while not ServerListe.AtEndOfStream
 ServerName=ServerListe.ReadLine
 i = instr(ServerName,",")
 if i>1 then
   ServerName = left(Servername,i-1)
 end if  
 call Schreiben(ServerName)     'getmids.txt fr diesen Server erstellen
wend
ServerListe.Close

if AnzahlSuchen=0 then
  wscript.echo "Keine Postings zum Laden per MsgId gefunden"
 else
  wscript.echo "Anzahl Postings zum Laden per MsgId: " & AnzahlSuchen
end if  

Wscript.DisconnectObject Hamster
WScript.DisconnectObject Dateisystem

'####################################################################

sub LogsLesen

dim LogNr,LogName                       'Nummer u. Name der Logdatei
dim Datei                               'Dateiobjekt
dim Zeile,Posit                         'zur Suche verwendet

'entsprechende Anzahl Log-Dateien verarbeiten
for LogNr=0 to LogAnzahl-1
 LogName=LogPfad & cStr(LogNr) & ".log"
 if DateiSystem.FileExists(LogName) then
   set Datei = DateiSystem.OpenTextFile(LogName,ForReading)
   while not Datei.AtEndOfStream
    Zeile=Datei.ReadLine
    'mu angepat werden falls sich das Logformat ndert!
    Posit = InStr(Zeile,"> ARTICLE <")
    if Posit>0 then
      IdDazu(Mid(Zeile,Posit+10))
    end if
   wend
 end if
next
end sub

'####################################################################

sub Schreiben(ServerOrdner)

dim AlleLokal                   'sichert AlleMsgIds
dim IdDatei                     'vollst. Name getmids.txt
dim Datei                       'Dateiobject getmids.txt
dim IdFeld                      'alle MsgId als Feld
dim Posit                       'fr Schleife Felddurchlauf
dim Zeile                       'eine Zeile der getmids.txt
dim AnzahlAktuell               'wieviel MsgId nachladen fr akt. Server

if not DateiSystem.FileExists(ServerPfad & ServerOrdner & "\groups.txt") then
  wscript.echo("Servername """ & ServerOrdner & """ unklar")
  wscript.quit
end if

AlleLokal = AlleMsgIds
AnzahlAktuell=0
IdDatei = ServerPfad & ServerOrdner & "\getmids.txt"

'evtl. in getmids.txt bereits vorhandene MsgIds einlesen
if DateiSystem.FileExists(IdDatei) then
 set Datei = DateiSystem.OpenTextFile(IdDatei,ForReading)
 while not Datei.AtEndOfStream
  Zeile=Datei.ReadLine
  IdDazu(Zeile)
 wend 
 Datei.Close
end if

IdFeld = Split(AlleMsgIds,"")

'MsgIds im Hamster suchen, wenn nicht vorhanden an Datei ausgeben
set Datei = DateiSystem.OpenTextFile(IdDatei,ForWriting,True)
for Posit=0 to UBound(IdFeld)
 Datei.WriteLine(IdFeld(Posit))
 AnzahlAktuell=AnzahlAktuell+1
next
Datei.Close

if AnzahlAktuell=0 then
  'keine fr diesen Server zu laden, also getmids.txt lschen
  DateiSystem.DeleteFile(IdDatei)
end if

AlleMsgIds=AlleLokal
end sub

'####################################################################

sub IdDazu(MsgId)
dim GroupName,ArtNo             'fr Suche im Hamster

 if InStr(AlleMsgIds,MsgId)=0 then
   'wenn die MsgId noch nicht in der Liste ist anfgen
   Groupname=""
   ArtNo=0
   if not Hamster.NewsLocateMID(MsgId,(GroupName),(ArtNo)) then
     'wenn Artikel noch nicht im Hamster vorhanden
     AnzahlSuchen=AnzahlSuchen+1
     if AlleMsgIds<>"" then
       AlleMsgIds=AlleMsgIds & ""
     end if  
     AlleMsgIds=AlleMsgIds & MsgId
   end if  
 end if
end sub

