'====================================================================
' MailStatistics.vbs					Version 1.01
'
' (c) 1999, 2000 by Wolfgang Jth <wjaeth@bigfoot.de>
'
' Zeigt an, wieviele Mails aktuell in welchen Mailboxen 'herumlungern'
'
' Zum Starten vom Hamster aus kann man eine hsc-Datei mit folgendem
' Inhalt verwenden:
'         start.nowait "Wscript.exe MailStatistics.vbs"
'
'====================================================================
'
' Die Verwendung erfolgt auf eigene Verantwortung. Der Autor schliet
' jegliche Haftung aus.
'
' Diese Datei darf fr private Zwecke frei verwendet, kopiert oder
' weitergeben werden, solange der Inhalt unverndert bleibt. nderungen
' oder Anpassungen am Quelltext bedrfen der Genehmigung des Autors.
'
' Der Inhalt dieser Datei ist und bleibt geistiges Eigentum des Autors.
'
'====================================================================
'
' Updates:
'
' Version 1.1
'
' - Es werden nicht mehr alle Dateien in den jeweiligen Verzeichnissen
'   gezhlt, sondern nur noch die mit der 'richtigen' Endung ('.msg'). 
'   (Anpasung an die Existenz von Korrnews)
'
'
'====================================================================



' Allgemeine Programmbedingungen
'--------------------------------
Option explicit				' Variablendeklaration erzwingen
On error resume next			' Kein Abbruch bei Fehler



' Deklarationen
'---------------
Const Mail_Out = "Mail.Out"	' diverse Unterverzeichnisse
Const subdirMails = "Mails\"
Const subdirNewsOut = "Groups\News.Out"

Dim fileSystem			' FileSystem-Objekt
Dim hamster			' Hamster-Objekt

Dim hamsterPath			' Hamster-Pfad
Dim msgHeadline			' MessageBox-Titelzeile 
Dim msgNothing			' MessageBox-Text, wenn nichts gefunden
Dim msgSomething		' MessageBox-Text, wenn etwas gefunden
Dim msgFound			' MessageBox-Text, was gefunden wurde



Function ScanAccount (FileSystem, AccountPath, AccountName)
'===========================================================
    Dim MailAccount
    Dim MailCount, ExistingMail

    Set MailAccount = FileSystem.GetFolder(AccountPath)
    MailCount = 0
    for each ExistingMail in MailAccount.Files
        If (LCase (Right (ExistingMail.Name, 4)) = ".msg") Then
            MailCount = MailCount + 1
        End If
    next
    if MailCount > 0 then 
        ScanAccount = Space(8) & CStr(MailCount) & "  " & AccountName & vbCr
    else
        ScanAccount = ""
    end if
End Function



Function ScanMailIn (FileSystem, AllAccounts)
'=============================================
    Dim CAccounts, MailAccount

    Set CAccounts = FileSystem.GetFolder (AllAccounts)
    For Each MailAccount in CAccounts.SubFolders
        if MailAccount.Name <> Mail_Out then
            ScanMailIn = ScanMailIn + ScanAccount (FileSystem, MailAccount.Path, MailAccount.Name)
        end if
    Next
End Function



Function GetStatus (FileSystem, HamsterPath)
'============================================
    Dim InStatus, OutStatus

    InStatus = ScanMailIn (FileSystem, HamsterPath & subdirMails)
    OutStatus = ScanAccount (FileSystem, HamsterPath & subdirMails & Mail_Out, "Mails")
    OutStatus = OutStatus + ScanAccount (FileSystem, HamsterPath & subdirNewsOut, "News")
    if Len (InStatus) > 0 then
        InStatus = "Eingang" & vbCr & InStatus
    end if
    if Len (OutStatus) > 0 then
        OutStatus = "Ausgang" & vbCr & OutStatus
    end if
    if Len (OutStatus) > 0 then			' Haben wir auch ausgehende Mails?
        if Len (InStatus) = 0 then
            InStatus = OutStatus			' Ja: Nur ausgehende Mails
        else
            InStatus = InStatus & vbCr & OutStatus	' Ja: Sowohl ein- und ausghende Mails
        end if
    end if
    GetStatus = InStatus
End Function



' Main
'======
Set fileSystem = WScript.CreateObject("Scripting.FileSystemObject")	' Initialisiere Filesystem-Object

Set hamster = WScript.CreateObject ("Hamster.App")			' Initialisiere Hamster-Objekt
if Not IsObject (hamster) then
    MsgBox "Hamster nicht gefunden", vbOkOnly+vbCritical
else
    hamsterPath = hamster.ControlGetPath				' Ermittle Hamster-spezifische Angaben
    msgSomething= "Pfad : " & Space(8) & hamsterPath & vbCr & vbCr
    msgNothing  = "Keine Mailings auf Lager." & " (" & hamsterPath & ")"
    msgHeadline = "Mailkonten-Status (V.1.1)  fr Hamster " & hamster.ControlGetVersion

    msgFound = GetStatus (FileSystem, hamsterPath)			' aktuellen Status ermitteln
    if Len (msgFound) > 0 then						' und ausgeben
        MsgBox msgSomething & msgFound, vbOkOnly+vbInformation, msgHeadline
    else
        MsgBox msgNothing, vbOkOnly, msgHeadline
    end if

    WScript.DisconnectObject hamster					' Aufrumen
end if
WScript.DisconnectObject fileSystem



