' Mailmove.vbs
' From: "Joachim Kromm" <Joachim.Kromm@gmx.de>
'
' Verteilung eingegangener Mails an Benutzer, die in der Datei
' Synonym.dat eingetragen wurden.
'
' >>>>>>>>>>>>>>>>>>>siehe liesmich.txt<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

Option Explicit

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

' Globale Variablen
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim FSO,WSH

Dim TabStop
Dim NewLine
Dim HamsterVerzeichnis

'Mailverzeichnisse
Dim MailIn
Dim MailOut

Dim MailAnzahl

Dim SynonymDatei

Dim Synonymanzahl

Dim SynonymName (50)
Dim SynonymAdresse (50)
Dim Mailnamen(150)

DIM logdatei, silent, logmode, local
Dim logwrite

' !!!!! Diese Konstante auf die eigene eMail Adresse anpassen !!!!
Const MailFrom = "!MAIL FROM: <hamster@hamster.home>"

Const RCPT = "!RCPT TO: "
Const XHdr = "X-Forward: Mailmove for Hamster - Version 1.0.1 beta by J. Kromm - "



' Constants for opening files


Const OpenFileForReading = 1
Const OpenFileForWriting = 2
Const OpenFileForAppending = 8

'Optionen fr die Mailbehandlung im Eingangsfach

Const Mailloeschen=0  'Weitergeleitete Mails werden im Admin-Postfach gelscht
Const Mailerhalten=1  'Weitergeleitete Mails bleiben im Admin-Postfach
Const Mailsichern =2  'Weitergeleitete Mails werden in den Ordner
                      'Hamsterverzeichnis\mailbackup verschoben

Const MailbackupVerzeichnis="mailbackup\"


Dim Mailbehandlung    'Diese Variable bestimmt, welche der o.g. Funktionen ausgefhrt
                      'wird.
Sub Main

        Dim Hamster
        Dim Syonyme
        Dim lauf, erg
        Dim s

        ' Set up global data.
        TabStop = Chr(9)
        NewLine = Chr(13)+Chr(10)

        Set FSO = Wscript.CreateObject("Scripting.FileSystemObject")
        Set WSH = CreateObject("WScript.Shell")
        Set Hamster = Wscript.CreateObject( "Hamster.App" )

        HamsterVerzeichnis=Hamster.ControlGetPath

        MailIn=HamsterVerzeichnis & "Mails\Admin\"

        ' Daten aus der Mailmove.ini lesen bzw. wichtige Variablen initialisieren
        MailmoveIni

        ' Log-Datei initialisieren, sofern Logfunktion aktiviert ist.
        openlog

        If FSO.FolderExists(MailIn) Then

          MailAnzahl=MailsZaehlen

         Else

          message "Das Verzeichnis fr eingegangene Mails existiert nicht!",vbCritical
          log "ERROR - Verzeichnis "+MailIn+" ist nicht vorhanden."
          CloseLog
          Exit Sub

        End IF

        If Mailanzahl= -1 Then
         message "Es liegen keine Nachrichten vor",vbCritical
         log "ERROR - Keine Nachrichten zum Bearbeiten gefunden!"
         CloseLog
         Exit Sub
        End If

        message "Es werden " & Mailanzahl+1 & " eMails bearbeitet", vbOKOnly
        log MailAnzahl+1 & " Mails(s) werden ueberprft und bearbeitet."

        MailOut=HamsterVerzeichnis &"Mails\Mail.Out\"


        SynonymDatei=HamsterVerzeichnis+"Synonym.dat"

        If FSO.FileExists (SynonymDatei) THEN
          SynonymAnzahl=GetSynonymanzahl
          log "Info - Synonymanzahl: " & SynonymAnzahl
         ELSE
          WScript.Echo "Die Synonym Datei wurde noch nicht angelegt."
          log "ERROR - "+SynonymDatei+" wurde nicht gefunden"
          CloseLog
          Exit Sub
        End If

        Select Case Mailbehandlung
          case Mailsichern
               log "Status - Sicherungsmodus fr bearbeitete Mails"
          Case Mailloeschen
               log "Status - Lschmodus fr bearbeitete Mails"
          Case Mailerhalten
               log "Status - Mails verbleiben im Adminordner"
        End Select

        If Mailbehandlung=Mailsichern Then
          erzeugeBackupVerzeichnis (Hamsterverzeichnis+MailbackupVerzeichnis)
          log "Status - Sicherungsverzeichnis "+ Hamsterverzeichnis+MailbackupVerzeichnis+" wurde angelegt."
        End If

        Mailsweiterleiten
        CloseLog
        Wscript.DisconnectObject Hamster

End Sub



' Zhlt die Dateien im Adminordner und liest die
' Dateinamen in das globale Array Mailnamen ein
Function MailsZaehlen
  Dim Folder
  Dim Dateien,File, Anzahl,Zaehler
  Set Folder = FSO.GetFolder(MailIn)
  Set Dateien = Folder.Files
  Anzahl=Dateien.Count
  Zaehler=0

  For each File in Dateien
        Mailnamen(Zaehler)=File.Name
        Zaehler=Zaehler+1
  Next
  MailsZaehlen=Anzahl-1

End Function

' Liest die Angaben aus der Synonymdatei
' in die globalen Arrays SynonymNamen
' und Synonymadresse ein
Function GetSynonymAnzahl
        Dim Synonym
        Dim S
        Dim File
        Dim Zaehler
        Set File = FSO.GetFile(SynonymDatei)
        Set Synonym = File.OpenAsTextStream(OpenFileForReading)
        Dim tempSyn

        Zaehler=0

        Do      While Not Synonym.AtEndOfStream
                tempSyn = Split (Synonym.ReadLine, "#", 2, 1)
                SynonymName(zaehler)=tempSyn(0)
                SynonymAdresse(zaehler)=tempSyn(1)
                zaehler=zaehler+1
        Loop
        Synonym.Close

        GetSynonymAnzahl = zaehler-1

End Function

'Mail "Name" einlesen.
Function ReadMail (name)
  Dim fso, f
  Set fso = CreateObject("Scripting.FileSystemObject")
  Set f = fso.OpenTextFile(MailIn+name, OpenFileForReading)
  ReadMail =  f.ReadAll
End Function

'Suche nach Adresse mit regulaerem Ausdruck in einer Headerzeile
Function Adressensuche(patrn, strng)
  Dim regEx, erg
  patrn="^[T|C][o|c]:\s"+patrn
  Set regEx = New RegExp
  regEx.Pattern = patrn
  regEx.IgnoreCase = True
  erg = regEx.Test(strng)

  Adressensuche=erg
End Function

' Alle Header der Mail nach "To" oder "Cc" scannen
Function ScanMail (name)
Dim m, f, nr, zeile, l, gefunden, test

    Set m = FSO.GetFile(MailIn+name)
    Set f = m.OpenAsTextStream(OpenFileForReading)
    gefunden=False
    Zeile=" "
    Do  While (Zeile <>"") AND (Not gefunden)
        Zeile = f.ReadLine
        For l=0 To SynonymAnzahl
          test=SynonymName(l)
          gefunden= Adressensuche (test,Zeile)
          If gefunden Then
             nr=l
             Exit For
          Else
             Nr= -1
         End IF
      Next
   Loop
   f.Close

   ScanMail=Nr
End Function

' Diese Routine leitet  alle erkannten Mails an die Anwender weiter.
Sub Mailsweiterleiten
 Dim lauf
  log "Info - Beginne Mailweiterleitung"
  If Mailanzahl=0 Then
   Mailbearbeiten (0)
   log "Info - Mail wurde bearbeitet"
  Else
   For lauf = 0 To Mailanzahl
    Mailbearbeiten lauf
    log "Info - Mail Nr. " & Lauf+1 & " von " & Mailanzahl+1 & " bearbeitet"
   Next
  End If
End Sub


' Unterroutine fuer Mailsweiterleiten.
' Bei lokaler Weiterleitung werden die Mails in die Postfaecher der
' Anwender kopiert.
' Wenn keine lokale Weiterleitung erfolgen soll, wird der Envelope-
' header der Mail angepasst und die Mail in den Ausgangsordner
' kopiert.
' Je nach Einstellung der Variablen Mailbehandlung werden die
' Mails anschliessend im admin-Postfach geloescht, nach Hamster\mailbackup
' verschoben oder bleiben im admin-Postfach.
Sub Mailbearbeiten (lauf)
Dim erg,s,meld,logmessage, erfolg, icon, XHdrFwd
   erg=scanMail (mailnamen(lauf))
   If erg <> -1 Then
    xHdrFwd= "X-Forwardtime: " & date & " " & time & Newline
    s=ReadMail (mailnamen(lauf))
    If local Then
      s=XHdr+Newline+XHdrFwd+s
      log "Info - " + mailnamen(lauf) + " lokale Weiterleitung an Postfach "+ SynonymAdresse (erg)
    Else
      s=MailFrom+Newline+RCPT+SynonymAdresse(erg)+Newline+XHdr+Newline+XHdrFwd+s
      log "Info - " + mailnamen(lauf) + " externe Weiterleitung an "+ SynonymAdresse (erg)
    End If
      MailSchreiben mailnamen(lauf), s, SynonymAdresse (erg)

      Select Case Mailbehandlung
          Case Mailloeschen
                   Maildelete (mailnamen(lauf))
                   meld="Die Mails im Adminpostfach wurden gelscht"
                   logmessage="Info - "+meld
                   icon=vbInformation
          Case Mailsichern
                   If VerschiebeDatei (mailnamen(lauf)) Then
                     meld = "Daten wurden in das Mailbackup- Verzeichnis gesichert"
                     icon=vbInformation
                     logmessage="Info - "+meld
                   Else
                     meld = "Datei "+ mailnamen(lauf) + " konnte nicht gesichert werden."+Newline
                     meld = meld + "Es ist eine gleichnamige Datei im Sicherungsverzeichnis vorhanden."+Newline
                     meld = meld + "Die Nachricht wurde im Admin-Ordner belassen."
                     icon=vbExclamation
                     logmessage="Nachricht "+ mailnamen(lauf) + " konnte nicht gesichert werden."

                  End If
          Case Else
                   meld = "Die weitergeleiteten Nachrichten verbleiben im Admin-Ordner"
                   logmessage="Info - "+meld
                   icon=vbInformation
      End Select
   Else
    meld = "Kein Synonym fr "+mailnamen(lauf)+" gefunden."
    logmessage = "Info - Mail "+mailnamen(lauf)+" nicht weiterbearbeitet. Kein Synonym gefunden"
   End If
    log logmessage
    message meld, vbOKOnly+icon
End Sub

' Unterroutine zum Schreiben einer einzelnen Mail.
' wird von Mailbearbeiten verwendet.
Sub MailSchreiben (Name, inhalt, localname)
 Dim pfad
 Dim TextStream
 If local Then
   Pfad=Hamsterverzeichnis+"Mails\"+localname+"\"
   If Not FSO.FolderExists (Pfad) Then
      log "ERROR - Ordner "+Pfad+" existiert nicht!"
      Exit Sub
   End If
   log "Info - lokaler Mailordner: "+pfad
 ELSE
   Pfad=Mailout
   log "Info - Externer Mailempfnger: "+ Pfad
 End If
 Set TextStream = FSO.CreateTextFile(Pfad+Name)
 TextStream.Write (inhalt)
 TextStream.Close
   log "Info - Mail " + Name+ " an " + localname + " zugestellt"
End Sub

' Unterroutine zum Lschen einer bestimmten Mail
Sub MailDelete (name)
  FSO.DeleteFile(MailIn + name)
End Sub

'Erzeugt ein Mailbackupverzeichnis, sofern dieses nicht bereits
'existiert.
Sub ErzeugeBackupVerzeichnis (Pfad)
 Dim Backupordner
 If Not FSO.FolderExists(Pfad) Then
    Set Backupordner = FSO.CreateFolder(Pfad)
  End If
 End Sub

'Verschiebt eine Mail, sofern keine gleichnamige Datei im
'Backup-ordner vorhanden ist.
Function VerschiebeDatei (name)
  DIM erfolg
    If Not Fso.Fileexists (Hamsterverzeichnis+MailbackupVerzeichnis+name) Then
    fso.Movefile MailIn+name,Hamsterverzeichnis+MailbackupVerzeichnis
     erfolg=TRUE
    ELSE
     erfolg=FALSE
  End If
  VerschiebeDatei=erfolg
End Function

'Verschiebt alle Mails
Sub VerschiebeMails
Dim lauf
 If Mailanzahl=0 Then
    VerschiebeDatei (Mailnamen (0))
  Else
   For lauf = 0 To Mailanzahl
     VerschiebeDatei (Mailnamen (lauf))
   Next
  End If
End Sub

' Initialisiert die Logfunktion
sub OpenLog
 IF logmode THEN
   REM Set fso = CreateObject("Scripting. FileSystemObject")
   Set logwrite = fso.OpenTextFile(hamsterverzeichnis+logdatei, OpenFileForAppending, True)
   logwrite.Writeline (String (80,"="))
   logwrite.Writeline ("Beginn der Sitzung: "& date & " : " & time)
 End IF
End Sub

' Schliesst die Logdatei
sub CloseLog
 If logmode THEN
    logwrite.Writeline ("Ende der Sitzung: " & date & " : " & time)
 End If
End Sub
' Schreibt eine Logzeile in die Logdatei
sub log (nachricht)
 If logmode Then
   logwrite.Writeline (Date & ": " & Time & " | " & nachricht)
 End If
End Sub

' Gibt eine Popup-Meldung aus
sub message (nachricht, icon)
  If Not silent Then
    wsh.Popup nachricht, 3, "Mailmove", vbOKOnly+icon
  End IF
End Sub

'berprft, ob die Mailmove.ini vorhanden ist und liest die dortigen Werte aus.
'Sollte die mailmove.ini nicht vorhanden sein, werden die Programmwerte gesetzt.
Sub MailmoveIni

Dim Zaehler, ini, tempini, s, File

        logdatei="mailmove.log"
        silent=FALSE
        logmode=TRUE
        local=TRUE
        Mailbehandlung = Mailsichern

        If Fso.Fileexists (Hamsterverzeichnis+"mailmove.ini") Then
         Set File = FSO.GetFile(Hamsterverzeichnis+"mailmove.ini")
         Set ini = File.OpenAsTextStream(OpenFileForReading)

             Do While Not ini.AtEndOfStream
                s=ini.ReadLine
                ' Kommentarzeilen sollen ausgelassen werden.
                  If left (s,1) <>"#" Then
                    tempini = Split (s, "=", 2, 1)
                    tempini(0)=UCase (Tempini(0))
                    Select Case tempini (0)
                       Case   "LOGDATEI"
                          logdatei=Tempini (1)
                       Case   "SILENT"
                          If tempini(1)="1" Then
                            silent=True
                          ELSE
                            silent=FALSE
                          END IF
                       Case "LOGMODE"
                          If tempini(1)="1" Then
                            Logmode=True
                          ELSE
                            LogMode=FALSE
                          END IF

                       CASE "LOCAL"
                          If tempini(1)="1" Then
                            local=True
                          ELSE
                             local=FALSE
                          END IF
                      CASE "BACKUP"
                          Select Case Tempini(1)
                            Case 0
                              Mailbehandlung = Mailloeschen
                            Case 1
                              Mailbehandlung = Mailerhalten
                            Case 2
                              Mailbehandlung = Mailsichern
                           End Select
                    End Select

                  End If
         Loop
         ini.Close

       End IF
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''
'                Aufruf der Hauptroutine              '
''''''''''''''''''''''''''''''''''''''''''''''''''''


