#!/usr/bin/perl

###################################################
# oxfix simple Version 2.02  Datum: 1999/11/02
# (c) Jrgen Schick <twister@earthling.net>
#
# vereinfachte Scriptfassung von oxfix V2.02 in
# "minimal" Perl. Erstellt unter weitestgehendem
# Verzicht auf Perl-spezifische Funktionen oder
# Regular Expressions und vollstndig kommentiert,
# um das bertragen in andere Programmiersprachen
# aus der Kategorie Basic mit hnlichem Befehlssatz
# zu ermglichen.
#
# Das vorliegende Script ist nur zusammen mit einem
# installierten Perl-Interpreter funktionsfhig!
#
#
# Erluterungen zur Perl Syntax:
#
# Variable: $variable
# Feld: @feld
# Feld Element: $feld[index]
# Unterprogrammaufruf: &routine(Parameter)
# Funktionen: Funktion(Parameter)
#
# Schleifen, Bedingungen, Unterprogramme:
# Befehl/e/optionaleVariable (Parameter) {
#  Anweisungen ein/mehrzeilig ;
# }
#
# Texte/Stringvariablen verbinden:
# $string = 'text' . 'text2' . $text3 ;
#
# logisches UND: &&
# logisches ODER: ||
# String gleich: eq
# String ungleich: ne
###################################################


### Patch-Parameter Defaulteinstellung ###

# lokale Hamster IP-Adresse

$ip = '127.0.0.1';


# FQDN for Message-ID (aus dem entsprechenden Eintrag in der Hamster-
# Konfiguration bernehmen und anstelle von localhost hier eintragen!)

$fqdn = 'localhost';


# relativer Pfad zum Hamster News-Out Verzeichnis

$newsdir = 'groups/news.out';


# relativer Pfad zum Hamster Mail-Out Verzeichnis

$maildir = 'mails/mail.out';


# Dateinamenerweiterung der Hamster News-Files

$newsfile = '.msg';


# Dateinamenerweiterung der Hamster Mail-Files

$mailfile = '.msg';


# Patch fr News-Messages ausfhren yes oder no

$news = 'yes';


# Patch fr Mail-Messages ausfhren yes oder no

$mail = 'yes';


# Received-Headerzeile in Mails anpassen (yes) oder lschen (no)

$received = 'yes';


# In-Reply-To-Headerzeile bei vorhandener References-
# Headerzeile in Mails einfgen yes oder no

$in_reply_to = 'yes';


## einzufgende X-Headerzeilen fr News-Messages

# leeres Feld @xnews anlegen
@xnews = ();

# ab hier News X-Headerzeilen als Elemente des Feldes
# @xnews einfgen z.B.:

push(@xnews,'X-No-Archive: Yes');

# weiter z.B.: push(@xnews,'X-Headerzeile:'); ... usw.


## einzufgende X-Headerzeilen fr Mail-Messages

# leeres Feld @xmail anlegen

@xmail = ();

# ab hier Mail X-Headerzeilen als Elemente des Feldes
# @xmail einfgen

# z.B.: push(@xmail,'X-Headerzeile:'); ... usw.


## einzufgende gemeinsame X-Headerzeilen fr News-
## und Mail-Messages

# leeres Feld @xcommon anlegen

@xcommon = ();

# ab hier gemeinsame X-Headerzeilen als Elemente des Feldes
# @xcommon einfgen

# z.B.: push(@xcommon,'X-Headerzeile:'); ... usw.



### Spezielle Variablen ###

# ASCII-Codes fr Zeilenumbruch chr(13)chr(10) in Stringvariable wandeln

 $linefeed = "\n";


# fehlerhaften und korrekten Signaturtrenner definieren

 $sig_wrong = '--'.$linefeed;
 $sig_ok = '-- '.$linefeed;



### Patch-Aufruf fr News falls Parameter $news gleich yes ###

if ($news eq 'yes') {


# zu bearbeitendes Verzeichnis (News-Out) setzen

 $directory = $newsdir;


# Dateinamenerweiterung der Message-Files (News) setzen

 $filetype = $newsfile;


# Patchroutine aufrufen

 &patch();

}


### Patch-Aufruf fr Mails falls Parameter $mail gleich yes ###

if ($mail eq 'yes') {


# zu bearbeitendes Verzeichnis (Mail-Out) setzen

 $directory = $maildir;


# Dateinamenerweiterung der Message-Files (Mail) setzen

 $filetype = $mailfile;


# Patchroutine aufrufen

 &patch();

}


# Hauptprogramm-Ende



### Unterprogramm patch ###

sub patch {

## alle Directory-Eintrge des vorgegebenen Verzeichnisses
## in das Feld @files einlesen

# Directory zum Lesen ffnen

 opendir(D,$directory);


# alle Directory-Eintrge als Elemente ins Feld @files einlesen

  @files = readdir(D);


# Directory schliessen

 closedir(D);


## alle Directory-Eintrge mit der vorgegebenen Dateinamenerweiterung
## fr Mail- bzw. News-Messages aus dem Feld @files herausfiltern,
## jeweils um den Verzeichnispfad ergnzen und ins Feld @messages
## bernehmen


# Feld @messages leeren

 @messages = ();


# Schleife ber alle Elemente des Feldes @files

 foreach $file (@files) {


 # Dateinamenerweiterung des jeweiligen Directory-Eintrags bestimmen

  $offset = length($file) - length($filetype);
  $extension = substr($file,$offset,length($filetype));


 # falls Dateinamenerweiterung mit Vorgabe bereinstimmt ...

  if ($extension eq $filetype) {


 # ... dann Dateinamen um den Verzeichnispfad ergnzen ...

   $file = $directory.'/'.$file;


 # ... und als nchstes Element ins Feld @messages bernehmen

   push(@messages,$file);

  }

 }


## gefundene Mail- bzw. News-Messages nacheinander jeweils
## zeilenweise als Elemente in das Feldes @filetmp einlesen,
## alle Message-Zeilen berprfen und gegebenenfalls
## vorgegebene Ersetzungen/Ergnzungen durchfhren
 
# Haupt-Schleife ber alle gefundenen Message-Dateien
# (Elemente des Feldes @messages)

 foreach $file (@messages) {


# Felder @filetmp und @lines leeren und Zhler lschen

  @filetmp = ();
  @lines = ();
  $index = 0;
  $zeile = 0;


# jeweilige Message-Datei zum Lesen ffnen ...

  open(LOG,"$file");


# ... zeilenweise als Elemente ins Feld @filetmp einlesen,
# Zeilenzhler hochzhlen und letzte Textzeile ermitteln

   while (<LOG>) {
    $line = $_;
    push(@filetmp,$line);
    $index++;
    if ($line ne $linefeed) { $zeile = $index }
   }


# Message-Datei schliessen

  close(LOG);


# falls berflssige Leerzeilen am Message-Ende
# gefunden, dann diese Feldelemente leeren

  if ($zeile < $index) {
   for ($i=$zeile;$i<$index;$i++) { $filetmp[$i] = '' }
  }


# Zwischenspeicher-Variablen fr Received, Path und X-Posting-Agent lschen

  $rcv = '';
  $path = '';
  $xpagent = '';


# Markierung zur Erkennung des Message-Header-Teils setzen

  $headerflag = 1;



# Unter-Schleife ber alle Zeilen der Message (Elemente des Feldes @filetmp)

  foreach $line (@filetmp) {


# falls Zeile eine Headerzeile ...

   if ($headerflag == 1) {


# falls Message-ID: am Zeilenanfang gefunden (Message-ID-Headerzeile) ...

    if (substr($line,0,11) eq 'Message-ID:') {


 # ... dann falls in einer News-Message ...

     if ($news eq 'yes') {


  # ... Path-Headerzeile erzeugen ...

      $path = 'Path: '.$fqdn.'!not-for-mail'.$linefeed;


  # ... und als nchstes Element ins Feld @lines bernehmen

      push(@lines,$path);


 # ... oder falls in einer Mail-Message ...

     } else {


 ## ... dann evtl. von Outlook Express 4.xx erzeugte MsgID anpassen

      $msgid = '';
      $laenge = length($line);


  # ganze Zeile zeichenweise nach Suchstring durchsuchen

      for ($i=0;$i<$laenge;$i++) {

       if (substr($line,$i,10) eq '$LocalHost') {


  # ... falls gefunden, dann Teilstring vor Suchstring und Teilstring
  # nach Suchstring bestimmen und beide miteinander verbinden

        $offset = $laenge - $i - 10;
        $msgid = substr($line,0,$i).substr($line,$i+10,$offset);

       }

      }

 # falls MsgID angepasst, dann Message-ID-Headerzeile ersetzen

      if ($msgid ne '') { $line = $msgid }

      
  # ... danach falls zuvor Received-Headerzeile zum Anpassen gefunden ...

      if ($rcv ne '') {


   # ... angepasste Received-Headerzeile erzeugen, diese als nchstes Element
   # ins Feld @lines bernehmen und Variable $rcv wieder lschen

       $rcv = 'Received: from '.$fqdn.' ('.$ip.') by '.$fqdn.' ('.$ip.') with smtp'.$rcv;
       push(@lines,$rcv);
       $rcv = '';

      }

     }

    }


# falls umgebrochener 2. Teil der Content-Type-Headerzeile von OE oder eine
# Path-Headerzeile gefunden, dann die Zeilenvariable lschen

    elsif (substr($line,1,20) eq 'charset="iso-8859-1"' || substr($line,0,5) eq 'Path:') { $line = '' }


# falls Received-Headerzeile in einer Mail-Message gefunden ...

    elsif (substr($line,0,9) eq 'Received:' && $news eq 'no') {


 # ... dann falls $received Parameter gleich yes ...

     if ($received eq 'yes') {


  # ... aktuelles Datum/Zeit in GMT holen und in Variable $rcv zwischenspeichern

      $gmt = 1;
      &get_time();
      $rcv = $zeit;

     }

  # ... Zeilenvariable lschen

     $line = '';

    }


# falls Date-Headerzeile gefunden ...

    elsif (substr($line,0,5) eq 'Date:') {


 # ... dann aktuelles Datum/Zeit in lokaler Zeitzone
 # holen und daraus neue Date-Headerzeile erzeugen

     $gmt = 0;
     &get_time();
     $line = $zeit;

    }


# falls References-Headerzeile in einer Mail-Message gefunden und
# $in_reply_to Parameter gleich yes...

    elsif (substr($line,0,11) eq 'References:' && $news eq 'no' && $in_reply_to eq 'yes') {


 # ... dann Zeile als nchstes Element ins Feld @lines bernehmen ...

     push(@lines,$line);


 # ... und fr die zustzliche neue In-Reply-To-Headerzeile
 # danach References durch In-Reply-To ersetzen

     $line = 'In-Reply-To'.substr($line,10,length($line)-10);

    }


# falls Content-Type-Headerzeile gefunden ...

    elsif (substr($line,0,25) eq 'Content-Type: text/plain;') {


 # ... dann daraus neue einzeilige Content-Type-Headerzeile erzeugen

     $line = 'Content-Type: text/plain; charset="iso-8859-1"'.$linefeed;

    }


# falls X-Posting-Agent-Headerzeile gefunden, dann diese in
# Variable zwischenspeichern und Zeilenvariable lschen

    elsif (substr($line,0,16) eq 'X-Posting-Agent:') {
     $xpagent = $line;
     $line = '';

    }


# Dummy-Abfrage, damit die X-Priority-Headerzeile in Mails nicht entfernt wird

    elsif ($news eq 'no' && substr($line,0,11) eq 'X-Priority:') { $news = 'no' }


# X-Headerzeilen (Zeile vorher umgewandelt in Kleinbuchstaben
# zum alternativen Erkennen von x- und X-) entfernen

    elsif (lc(substr($line,0,2)) eq 'x-') { $line = '' }


## falls 1. Leerzeile im Message-Header gefunden, dann davor alle X-Headerzeilen
## einfgen und $headerflag lschen (ab hier dann Message-Body)

    elsif ($line eq $linefeed) {


 # falls eine News-Message ...

     if ($news eq 'yes') {


  # ... dann X-Headerzeilen fr News einfgen, falls diese definiert

      for (@xnews) {
       if ($_ ne '') { push(@lines,$_.$linefeed) }
      }


 # falls eine Mail-Message ...

     } else {


  # ... dann X-Headerzeilen fr Mails einfgen, falls diese definiert

      for (@xmail) {
       if ($_ ne '') { push(@lines,$_.$linefeed) }
      }

     }


 # gemeinsame X-Headerzeilen einfgen, falls diese definiert

     for (@xcommon) {
      if ($_ ne '') { push(@lines,$_.$linefeed) }
     }


 # X-Posting-Agent-Headerzeile einfgen, falls zuvor gespeichert

     if ($xpagent ne '') { push(@lines,$xpagent) }


 # $headerflag lschen

     $headerflag = 0;

    }


# falls fehlerhafter Signaturtrenner im Message-Body gefunden, dann ersetzen

   } elsif ($line eq $sig_wrong) { $line = $sig_ok }


# falls Zeilenvariable nicht leer, dann diese Zeile als nchstes Element ins Feld @lines bernehmen

   if ($line ne '') { push(@lines,$line) }

  }


# jeweilige Message-Datei zum berschreiben ffnen ...

  open(LOG,">$file");


# ... und zeilenweise neu schreiben

   for (@lines) { print LOG "$_" }


# Message-Datei schliessen

  close(LOG);

 }


# Marke fr News-Messages lschen, in nchster
# Schleife dann Mail-Messages erwartet

 $news = 'no';

}


### Unterprogramm get_time ###

sub get_time {

## aktuelles Datum/Zeit in Abhngigkeit von $gmt (lokale Zeitzone
## oder GMT) bestimmen und in entsprechenden Variablen speichern

 # falls Date-Headerzeile ...

 if ($gmt == 0) {


  # Werte der Perl-Funktion Datum/Zeit (lokale Zeitzone) an Feld bergeben

  @date = localtime(time); # 1.)


 # falls Received-Headerzeile ...

 } else {


  # Werte der Perl-Funktion Datum/Zeit (GMT) an Feld bergeben

  @date = gmtime(time);

  # 2.) falls GMT-Zeitbestimmung nicht mglich, dann stattdessen
  # nur 1.) lokales Datum/Zeit bestimmen und auf die IF-ELSE-
  # Abfrage in Abhngigkeit von $gmt ganz verzichten
 
 }


# Sekunde zweistellig

 $sec = $date[0];
 if ($sec < 10) { $sec = '0'.$sec }


# Minute zweistellig

 $min = $date[1];
 if ($min < 10) { $min = '0'.$min }


# Stunde zweistellig

 $stunde = $date[2];
 if ($stunde < 10) { $stunde = '0'.$stunde }


# Monatstag zweistellig

 $tag = $date[3];
 if ($tag < 10) { $tag = '0'.$tag }


# Zeiger auf Monat (0-11)

 $monat = $date[4];


# Jahreszahl vierstellig

 $jahr = 1900 + $date[5];


# Zeiger auf Wochentag (0-6)

 $weekday = $date[6];


# Felder mit Monats- und Wochentags-Abkrzungen

 @mon = (Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec);
 @wtag = (Sun,Mon,Tue,Wed,Thu,Fri,Sat);


# bentigten formatierten Datum/Zeit-String erzeugen

 $time_now = $wtag[$weekday].', '.$tag.' '.$mon[$monat].' '.$jahr.' '.$stunde.':'.$min.':'.$sec;


 # falls Date-Headerzeile ...

 if ($gmt == 0) {


 # Zwischenspeichervariablen lschen

  $plus = 0;
  $tz = '';


  # Date-Headerzeile zeichenweise vom Zeilenende her beginnend
  # nach Position des + Zeichens der Zeitzonenangabe durchsuchen
  # und falls gefunden, Position in der Variable $plus speichern

  $laenge = length($line) - 1;

  for ($i=$laenge;$i>=0;$i--) {
   if (substr($line,$i,1) eq '+') { $plus = $i }
  }


  # falls + Zeichen gefunden ...

  if ($plus > 0) {


   # ... dann Zeitzonenangabe aus Date-Headerzeile isolieren und in $tz speichern

   $offset = $laenge - $plus + 1;
   $tz = ' '.substr($line,$plus,$offset);


  # falls + Zeichen nicht gefunden ...

  } else {


   # ... dann Zeitzonenangabe gleich Abk. fr Mitteleuropische Zeit

   $tz = ' CET';

  }


  # abschliessend formatierten String fr Date-Headerzeile erzeugen

  $zeit = 'Date: '.$time_now.$tz;


 # falls Received-Headerzeile ...

 } else {


  # ... dann formatierten GMT-String fr Received-Headerzeile erzeugen

  $zeit = ' ; '.$time_now.' GMT'.$linefeed;

  # Anmerkung: falls GMT-Zeitbestimmung nicht mglich, dann stattdessen oben unter
  # 1.) nur lokales Datum/Zeit bestimmen und hier in $zeit GMT durch CET ersetzen!

 }

}