'Autor:    Heiko Rost <heiko.rost@gmx.de>
'Version:  1.00

option explicit

dim RasDial_Connection,AktProvider         'Name der Verbindung
dim objArgs,Hamster,MiniOle,Shell,fso      'die OLE-Objekte
dim Datum,Zeit,Wochentag,VerbindungsNummer,IstFeier
dim MailSend, MailPull,NewsSend,NewsPull,OptPurge,OptDial
dim GMXfertig
dim anzahl
dim i,j,k

dim CrLf : CrLf  = chr(10)+chr(13)
const Wartezeit=5           'wieviel Sekunden nach Fehlversuch warten
const AnzahlVersuche=2      'wie oft _pro_Provider_ whlen

const ZeitSektion = "Heikos Stoppuhr"
dim   ZeitMittel, ZeitAnzahl,ZeitIni,ZeitAktiv

dim NNTPServer, SMTPServer, POP3Server, POP3Feld

set Shell   = wScript.CreateObject("wScript.Shell")
Set Hamster = Wscript.CreateObject("Hamster.App")
set MiniOle = wscript.createobject("ScriptFunctions.App")
set fso     = wscript.createobject("Scripting.FileSystemObject")

'verschiedene Voreinstellungen
RasDial_Connection = ""
MailSend=False : MailPull=false : NewsSend=False : NewsPull=False
OptPurge=false : OptDial=True

'Initialize Hamster-constants
Const HAM_PURGEOPT_DOALL     = &HF
Const HAM_PURGEOPT_DONEWS    = &H1
Const HAM_PURGEOPT_DOHISTORY = &H2
Const HAM_PURGEOPT_DOKILLS   = &H4
Const HAM_WAITIDLE_INFINITE  = 0


'Kommandozeile des Skriptes auswerten
Set objArgs = Wscript.Arguments
for i = 0 to ObjArgs.Count-1
 select case UCase(ObjArgs(i))
  case "/MAILSEND"
   MailSend=true
  case "/MAILPULL"
   MailPull=true
  case "/NEWSSEND"
   NewsSend=true
  case "/NEWSPULL"
   NewsPull=true
  case "/ALL"
   MailSend=true : MailPull=true : NewsSend=true : NewsPull=true
  case "/PURGE"
   OptPurge=true
  case else
   if left(ObjArgs(i),1)="/" then
     wScript.Echo("Was soll """ & ObjArgs(i) & """ denn bedeuten?")
     wScript.Quit
   end if  
   RasDial_Connection=ObjArgs(i)
 end select
next

if not (MailSend or MailPull or NewsSend or NewsPull or OptPurge) then
  wScript.Echo("Mir mte schon gesagt werden was ich jetzt tun soll...")
  wScript.Quit
end if

Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

'ermitteln, welche Zeit (mit/ohne Pull) Vorgabe fr GetRasLCR ist
ZeitIni=Hamster.ControlGetPath+"hamster.ini"
if NewsPull then
  ZeitMittel="MitNewsPullMittel"
  ZeitAnzahl="MitMewsPullAnzahl"
 else
  ZeitMittel="OhneNewsPullMittel"
  ZeitAnzahl="OhneNewsPullAnzahl"
end if
ZeitAktiv=MiniOle.IniRead(ZeitIni,ZeitSektion,ZeitMittel,60)

if MiniOle.GetRasConnection()<>"" then
  'Wenn schon Online dann nicht den Hamster whlen lassen
  OptDial=False
end if  

if (RasDial_Connection="") and OptDial then
  'Whlen verlangt und kein RAS-Name beim Aufruf angegeben: Liste von MiniOle holen
  RasDial_Connection=HoleRASNamen
end if  

if (RasDial_Connection="") and OptDial then
  'immer noch whlen verlangt, aber kein RAS-Name gesetzt: Fehler
  wScript.Echo("Mir fehlt der Name der DF-Verbindung")
  wScript.Quit
end if  

'wenn folgender Block ohne Kommentar, dann Sicherheitsabfrage vor Verbindung
'if OptDial and (MailSend or MailPull or NewsSend or NewsPull) then 
'  if MsgBox("Verbindung mit """ & RasDial_Connection & """  (" &_
'                        ZeitAktiv & " Sekunden) aufbauen?",vbYesNo,_
'                        "Verbindung besttigen")<>vbYes then
'    wScript.Quit
'  end if
'end if  

If OptPurge Then
   Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
   Hamster.ControlRunPurge HAM_PURGEOPT_DOALL
   Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
End If

'hier die verlangten Online-Aktionen starten
if MailSend or MailPull or NewsSend or NewsPull then
  'falls Hamster irgendwie beschftigt lieber warten
  Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE
  ZeitAktiv=now
  Hamster.ControlMessage 2,0
  if OptDial then
    'Bei Bedarf Verbindung aufbauen
    AktProvider=""
    while not hamster.rasisconnected and RasDial_Connection<>""
     i=instr(RasDial_Connection,":")
     if i=0 then
       AktProvider=RasDial_Connection
       RasDial_Connection=""
      else
       AktProvider=left(RasDial_Connection,i-1)
       RasDial_Connection=mid(RasDial_Connection,i+1)
     end if  
     anzahl = AnzahlVersuche
     do 
      anzahl=anzahl-1
      ZeitAktiv=now
      if not Hamster.rasdial(AktProvider,"","") and (anzahl<>0 or RasDial_Connection<>"") then
        if Shell.Popup("Wahlwiederholung starten?",WarteZeit,"Verbindungsfehler",5+32)=2 then
          wScript.Quit
        end if  
      end if
     loop until anzahl=0 or hamster.rasisconnected()
    wend 
    if not hamster.rasisconnected() then
      wscript.echo "Leider keine Verbindung"
      wscript.quit
    end if
  end if

  '***********************************************************************
  '* ab hier Anpassungen an den aktuellen DF-Zugang                     *
  '***********************************************************************

  'zuerst die Server, die bei allen Providern zur Verfgung stehen

  'Syntax: server,port;server,port...
  NNTPServer="news.easynews.net,nntp;msnews.microsoft.com,nntp;news.cis.dfn.de,nntp"

  'Syntax: serverPortuserpassaccountserverportuserpassaccount...
  POP3Server="uumail.de.uu.netpop3"+_
             "mail.telda.netpop3"+_
             "mail.ngi.depop3komtel"+_
             "pop.gmx.depop3admin,heiko"+_
             "pop.gmx.depop3$1jana,jana"

  'die providerabhngigen Server hinzufgen
  select case UCase(MiniOle.GetRasConnection())
   case "NGI BY CALL"
    SMTPServer="mail.ngi.de"
   case "KNUUT","0800 KNUUT","LOKALER KNUUT"
    NNTPServer=NNTPServer+";personalnews.de.uu.net,nntp"
    SMTPServer="uumail.de.uu.net"
   case "CBC KOMTEL"
    NNTPServer=NNTPServer+";news.komtel.net,nntp"
    SMTPServer="mail.komtel.net"
    POP3Server=POP3Server+"mail.komtel.netpop3komtel"
   case "MSN EASYSURF"
    SMTPServer="mail.gmx.de"
   case "SYNX"
    SMTPServer="mail.synx.de"
    NNTPServer=NNTPServer+";news.synx.de,nntp"
   case else
    NNTPServer=""               'alle Server versuchen
    SMTPServer="mail.gmx.de"    'Mails ber GMX ausliefern
  end select

  '***********************************************************************
  '* Ende der Anpassungen an den aktuellen DF-Zugang                    *
  '***********************************************************************

  POP3Feld=split(POP3Server,"")

  GMXFertig = false
  if MailSend and lcase(SMTPServer)="mail.gmx.de" then
    'falls Mails an GMX zu liefern: testen ob berhaupt welche im Ausgang
    if fso.GetFolder(hamster.controlgetpath+"\mails\mail.out").files.count>0 then
      'wenn ja, SMTP durch POP freischalten
      StartePOP3 true,false  'nur GMX abholen
      Hamster.ControlWaitIdle 4000 'klappt ab 1.3.15
      'i = now + 4/24/60/60 'jetzt + 4 Sekunden
      'do
      ' wscript.sleep 250
      'loop until Hamster.ControlIsIdle or now>=i
      GMXFertig=True
    end if  
  end if

  if NewsSend then
    Hamster.ControlRunNewsPost NNTPServer
  end if

  if MailPull then
    if GMXfertig then
      StartePOP3 false,true 'falls GMX weiter oben schon gestartet nur Nicht-GMX holen
     else
      StartePOP3 true,true  'alle POP3-Server abfragen
    end if  
  end if

  if MailSend then
    if SMTPServer<>"" then
      Hamster.ControlRunSendMail SMTPServer, "", ""
    end if
  end if

  if NewsPulL then
    Hamster.ControlRunNewsPull NNTPServer
  end if

  Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

  if OptDial then
    Hamster.RasHangup
  end if  

end if

if OptDial then
  'neue Zeiten errechnen
  ZeitAktiv=round(24*60*60*(now-Zeitaktiv))
  i=MiniOle.IniRead(ZeitIni,ZeitSektion,ZeitMittel,0)
  j=MiniOle.IniRead(ZeitIni,ZeitSektion,ZeitAnzahl,0)
  if j>100 then
    j=100
  end if  
  i=i*j+ZeitAktiv
  j=j+1
  i=round(i/j)
  MiniOle.IniWrite ZeitIni,ZeitSektion,ZeitMittel,i
  MiniOle.Iniwrite ZeitIni,ZeitSektion,ZeitAnzahl,j
  MiniOle.IniWrite ZeitIni,ZeitSektion,"LetzteVerbindung",ZeitAktiv
end if

hamster.ControlRunRebuildGlobalLists(0) 'sonst evtl. Denkminuten bei Neustart
Hamster.ControlWaitIdle HAM_WAITIDLE_INFINITE

Wscript.DisconnectObject Hamster
wScript.DisconnectObject MiniOle


'************************************************************************
'* Es wird eine nach Preis sortierte Liste aller in MiniOle definierten *
'* Provider erstellt.                                                   *
'************************************************************************
function HoleRASNamen
dim s,liste(),i,j
'LCRInfo-String aufsplitten
s = MiniOle.GetRasLcrInfo(ZeitAktiv,CrLf)
redim liste(1,0)
while s<>""
 i=instr(s,":")
 liste(0,ubound(liste,2))=trim(left(s,i-1))
 s=mid(s,i+1)
 i=instr(s,CrLf)
 if i=0 then
   liste(1,ubound(liste,2))=cdbl(trim(s))
   s=""
  else
   liste(1,ubound(liste,2))=cdbl(trim(left(s,i-1)))
   s=mid(s,i+len(CrLf))
 end if
 if s<>"" then
   redim preserve liste(1,ubound(liste,2)+1)
 end if  
wend
'RAS-Liste nach Kosten sortieren
for i=ubound(liste,2) to 1 step -1
 for j=0 to i-1
  if liste(1,j)>liste(1,j+1) then
    s=liste(0,j):liste(0,j)=liste(0,j+1):liste(0,j+1)=s
    s=liste(1,j):liste(1,j)=liste(1,j+1):liste(1,j+1)=s
  end if
 next
next
'gesamtstring ausgeben, Provider mit : getrennt, preiswertester zuerst
s=""
for i=0 to ubound(liste,2)
 if s<>"" then
   s=s+":"
 end if  
 s=s+liste(0,i)
next
HoleRasNamen=s
end function


'*****************************************************************************
'* Die POP3-Abfrage wird gestartet. Beim Aufruf mu angegeben werden, ob GMX *
'* und/oder nicht-GMX-Server abgearbeitet werden sollen                      *
'*****************************************************************************
sub startePOP3(GMX,Andere)
dim Server, Port, User, Pass, Account
dim Nummer,feld, Starte
for Nummer=lbound(POP3Feld) to ubound(POP3Feld)
 feld=split(POP3Feld(Nummer),"")
 Server=Feld(0)
 if ubound(Feld)>=1 then
   Port=feld(1)
  else
   Port="POP3"
 end if
 if ubound(Feld)>=2 then
   User=feld(2)
  else
   User=""
 end if
 if ubound(Feld)>=3 then
   Pass=feld(3)
  else
   Pass=""
 end if
 if ubound(Feld)>=4 then
   Account=feld(4)
  else
   Account=""
 end if
 if instr(ucase(Server),".GMX.")<>0 then
   'ein GMX-Server
   Starte=GMX
  else
   'irgendein anderer Server
   Starte=Andere
 end if
 if Starte then
   'wscript.echo Server  & " | " & port & " | " & user & " | " & pass & " | " & account
   Hamster.ControlRunFetchMail Server,Port,User,Pass,Account
 end if
next
end sub

