'Autor:    Heiko Rost <heiko.rost@gmx.de>
'Version:  1.00

option explicit

const MODUS = 3                            '1:wochenweise, 2:14 Tage, 3: monatsweise
const PFAD  = "D:\DOWNLOAD\HAMSTER\LOGS\"  'Logpfad
const MAXLOG = 100                         'wieviele Hamsterlogs max. verarbeiten

dim ErsterTag,EinTag,Heute,nummer
dim fso
dim d,m,j,a

set fso = wscript.CreateObject("Scripting.FileSystemObject")

Heute = Date
ErsterTag = Heute
select case MODUS
 case 1 : ErsterTag = ErsterTag - 6
 case 2 : ErsterTag = ErsterTag - 13
 case 3 : d = day(ErsterTag) : m = month(erstertag) : j = year(ErsterTag)
          m = m-1
          if m=0 then
            j = j-1 : m = 12
          end if
          do
           d = d+1
           if d > 31 then
             m = m + 1 : d = 1
             if m > 12 then
               j = j+1 : m = 1
             end if
           end if  
           a = d & "." & m & "." & j
          loop until IsDate(a)
          ErsterTag = cDate(a)
 case else wscript.echo "Rotationsmodus unklar"
           wscript.quit
end select

'alle Logs testet, ob zu alt und evtl. lschen
for EinTag = ErsterTag to Heute
 TesteLogDatei(EinTag)
next

'jetzt die Hamsterlogs testen, Nr. 0 vorsichtshalber auslassen
for Nummer = MAXLOG to 1 step -1
 VerarbeiteLog(Nummer) 
next

'#########################################################################
'# Ein Datum aus einer Logzeile wird in ein vbs-Datum gewandelt          #
'#########################################################################
function LogDatum(Zeile)
dim a
LogDatum = null
if len(Zeile)>=10 then
  a = mid(Zeile,9,2) & mid(Zeile,5,4) & left(Zeile,4)
  if IsDate(a) then
    LogDatum = cDate(a)
  end if
end if  
end function

'#########################################################################
'# das Hamsterlog mit der entsprechenden Nummer wird verarbeitet         #
'#########################################################################
sub VerarbeiteLog(Nummer)
dim QuellName,QuellDatei,ZielName,ZielDatei,Zeile,a,LogOk
LogOk=False
QuellName = pfad & Nummer & ".log"
if fso.FileExists(QuellName) then
  set QuellDatei = fso.OpenTextFile(Quellname,1)
  if not QuellDatei.AtEndOfStream then
    Zeile = QuellDatei.ReadLine
    QuellDatei.Close
    set QuellDatei = fso.OpenTextFile(Quellname,1)
    a = LogDatum(Zeile)
    if not IsNull(a) then
      LogOk=True
      TesteLogDatei(a)
      ZielName = LogName(a)
      set ZielDatei = fso.OpenTextFile(ZielName,8,true)
      while not QuellDatei.AtEndOfStream
       Zeile = QuellDatei.Read(1000000)
       ZielDatei.Write(zeile)
      wend 
    end if
  end if
  QuellDatei.Close
  if logok then 
    fso.deletefile(quellname)
  end if  
end if
end sub

'#########################################################################
'# Die zum Datum gehrende Logdatei wird getestet, ob das Datum in der   #
'# 1. Zeile vor dem angegebenen Vergleichsdatum liegt. Wenn ja, ist die  #
'# Datei zu alt und wird gelscht                                        #
'#########################################################################
sub TesteLogDatei(Datum)
dim Logdatei,datei,Zeile,ZuAlt,a
LogDatei = LogName(Datum)
if fso.FileExists(LogDatei) then
  set datei = fso.OpenTextFile(LogDatei,1)
  if not datei.atendofstream then
    a = LogDatum(Datei.ReadLine)
    if IsNull(a) then
      ZuAlt = true
     else
      if a<Datum then
        ZuAlt = true
      end if
    end if
   else
    ZuAlt = true
  end if  
  datei.close
  if ZuAlt then
    fso.deletefile(LogDatei)
  end if  
end if
end sub

'#########################################################################
'# Es wird der zum angegebenen Datum gehrige Logname ermittelt          #
'#########################################################################
function LogName(Datum)
dim i
select case modus
 case 1 : i = WeekDay(Datum,2)
          LogName = Pfad & "wota" & i & "-" & WeekdayName(i,true,2) & ".log"
 case 2 : i = datum - cdate("1.1.1990")
          i = (i mod 14) & ".log"
          if len(i)<6 then
            i = "0" & i
          end if
          LogName = Pfad & "tag" & i
 case 3 : i = day(datum) & ".log"
          if len(i)<6 then
            i = "0" & i
          end if
          LogName = Pfad & "monat" & i
end select 
end function
