#
# sendmail.pl for Juergen Haible's Hamster
#
# Purpose:
#
# 1.
#
# The e-mail provider GMX (www.gmx.net) allows to use any adress in
# From:-header if the envelope-from adress is set to your GMX-adress.
# This script changes the envelope-from of mails stored in Hamster's
# Mail.Out-directory into you GMX adress the way they can be sent via GMX.
#
# 2.
#
# Additionally you can make this script to delete some needless or
# unwanted header lines like 'Received: by localhost ... from localhost',
# and insert lines which your mail-reader does not set (the example given
# below is rather funny)
#
#
# This script is provided "as-is" without any warranty. Usual disclaimers
# apply. It is freeware in the sense of the well-known GPL.
# Copyright (c) 1999 Georg Burkhard <Georg.Burkhard@roma-online.de>
#
#
# Example for a Hamster script which calls this Perl script:
#
# -----
# fetchmail "pop.gmx.de"
# wait.idle
# start.wait "perl sendmail.pl"
# sendmail "mail.gmx.de" "" ""
# -----
#
# You may wish to read the configuration section before you use the script.
# ;-)

# --- Configuration ----------------------------------------------------

# Set $envelope_from to the e-mail-Adress you want to have it. Use
# single quotation marks. If you don't want to change the adress, leave
# the variable empty, i.e. $envelope_from='';
$envelope_from='';

#
@delete_lines=("^Received: ","\twith smtp ;");

#
@insert_lines=("X-Favorite-Pet: Hamster");

# Set $debug=1 to keep copies of the outgoing mails in your mail.out-
# directory, after they are changed by the script. This is especially
# useful for debugging. The files will have the extension ".deb".
$debug=0;

# ----------------------------------------------------------------------


if ((@delete_lines==()) && (@insert_lines==()) && ($envelope_from eq ""))
  {
    print "Nothing to do!";
    exit;
  }

use Win32::OLE;

my $Hamster = Win32::OLE->new("Hamster.App");
$path=$Hamster->ControlGetPath;
$path=join "",($path,"Mails/Mail.out/");
$path=~ s/\\/"\/"/eg;

opendir(DIR, $path) || die "Can't read direcotry $path!";
@file=readdir(DIR);
closedir DIR;

for (@file)
  {
    if ($_=~ /\.msg/)
      {
        modify ("$path$_");
      }
  }

undef $Hamster;


sub modify {

  my $file=$_[0];
  my $filename=$file;
  $filename=~ s/\//'\\'/eg;
  my $fulltempfilename=join "",(substr($filename,0,rindex($filename,"."))
      ,".bak");
  my $fulldebugfilename=join "",(substr($filename,0,rindex($filename,"."))
      ,".deb");
  my $tempfilename=join "",
    (substr($filename,rindex($filename,"\\")+1,
    rindex($filename,".")-rindex($filename,"\\")-1)
    ,".bak");
  my @line=(),@header=(),@body=();

  print "processing $file\n";

  open (H,"$file");
  while (<H>)
    {
      push (@line, $_);
    }
  close (H);
  
  system ("if exist $fulltempfilename del $fulltempfilename");
  system ("ren $filename $tempfilename");

  if ($envelope_from ne "")
    { $line[0]="!MAIL FROM: <$envelope_from>\n"; }

  my $header=1;
  my $i;
  for ($i=2;$i<=$#line;$i++)
    {
      if ($header==1)
        {
          push @header,$line[$i];
        }
      else
         {
           push @body,$line[$i];
         }
      my $b=$line[$i];
      chomp $b;
      if ($b eq "")
        { $header=0; }
    }

  for my $delete_line (@delete_lines)
    {
      for (@header)
        {
          if ($_=~ /$delete_line/)
            { $_=""; }
        }
     }
  $header[$#header]="";
  for (@insert_lines)
    {
      push @header,"$_\n";
    }
  push @header,"\n";

  open (H,">$file");
  print H $line[0];
  print H $line[1];
  for (@header)
    { print H $_; }
  for (@body)
    { print H $_; }
  close (H);

  system ("if exist $fulltempfilename del $fulltempfilename>nul");

  if ($debug==1)
    {
      system ("if exist $fulldebugfilename del $fulltempfilename>nul");
      system ("copy $filename $fulldebugfilename>nul");
    }
}
